/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.smb;

import com.xebialabs.overthere.cifs.PathMapper;
import java.util.ArrayList;
import java.util.Map;

public abstract class SmbPaths {
    public static final char SLASH = '\\';
    public static final String EMPTY = "";

    static String getShareName(String sharePath) {
        int i = sharePath.indexOf(92);
        if (i != -1) {
            return sharePath.substring(0, i);
        }
        return sharePath;
    }

    static String getSharePath(String hostPath, Map<String, String> pathMappings) {
        int last;
        PathMapper mapper = new PathMapper(pathMappings);
        String p = mapper.toSharedPath(hostPath);
        int first = p.indexOf(92);
        if (first == (last = p.lastIndexOf(92)) && p.endsWith(String.valueOf('\\'))) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    static String getPathOnShare(String sharePath) {
        int i;
        if (sharePath.endsWith(String.valueOf('\\'))) {
            sharePath = sharePath.substring(0, sharePath.length() - 1);
        }
        if ((i = sharePath.indexOf(92)) != -1) {
            return sharePath.substring(i + 1, sharePath.length());
        }
        return EMPTY;
    }

    static String escapeForwardSlashes(String hostPath) {
        return hostPath.replace('/', '\\');
    }

    static String getParentPath(String sharePath) {
        int i;
        if (sharePath.endsWith(String.valueOf('\\'))) {
            sharePath = sharePath.substring(0, sharePath.length() - 1);
        }
        if ((i = sharePath.lastIndexOf(92)) != -1) {
            return sharePath.substring(0, i);
        }
        return null;
    }

    static String getFileName(String sharePath) {
        int i = sharePath.lastIndexOf(92);
        if (i != -1) {
            return sharePath.substring(i + 1);
        }
        return sharePath;
    }

    static String join(String parent, String child) {
        return parent + "\\" + child;
    }

    static String[] getPathListFromOuterToInner(String sharePath) {
        String[] split = sharePath.split("\\\\");
        Object path = EMPTY;
        ArrayList<Object> l = new ArrayList<Object>();
        for (String s : split) {
            path = (String)path + String.valueOf(((String)path).isEmpty() ? EMPTY : Character.valueOf('\\')) + s;
            l.add(path);
        }
        return l.toArray(new String[l.size()]);
    }
}

