/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.util.UrlPathHelper;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class ResourceController {
    private static Log logger = LogFactory.getLog(ResourceController.class);
    private ResourceRepository resourceRepository;
    private EnvironmentRepository environmentRepository;
    private Map<String, ResourceEncryptor> resourceEncryptorMap = new HashMap<String, ResourceEncryptor>();
    private UrlPathHelper helper = new UrlPathHelper();
    private boolean encryptEnabled = false;
    private boolean plainTextEncryptEnabled = false;

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository, Map<String, ResourceEncryptor> resourceEncryptorMap) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
        this.resourceEncryptorMap = resourceEncryptorMap;
        this.helper.setAlwaysUseFullPath(true);
    }

    public ResourceController(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
        this.resourceRepository = resourceRepository;
        this.environmentRepository = environmentRepository;
        this.helper.setAlwaysUseFullPath(true);
    }

    public void setEncryptEnabled(boolean encryptEnabled) {
        this.encryptEnabled = encryptEnabled;
    }

    public void setPlainTextEncryptEnabled(boolean plainTextEncryptEnabled) {
        this.plainTextEncryptEnabled = plainTextEncryptEnabled;
    }

    @GetMapping(value={"/{name}/{profile}/{label}/**"})
    public String retrieve(@PathVariable String name, @PathVariable String profile, @PathVariable String label, ServletWebRequest request, @RequestParam(defaultValue="true") boolean resolvePlaceholders, @RequestHeader(value="Accept-Charset", required=false, defaultValue="UTF-8") String acceptedCharset) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.retrieve(request, name, profile, label, path, resolvePlaceholders, acceptedCharset);
    }

    @GetMapping(value={"/{name}/{profile}/{path:.*}"}, params={"useDefaultLabel"})
    public String retrieveDefault(@PathVariable String name, @PathVariable String profile, @PathVariable String path, ServletWebRequest request, @RequestParam(defaultValue="true") boolean resolvePlaceholders, @RequestHeader(value="Accept-Charset", required=false, defaultValue="UTF-8") String acceptedCharset) throws IOException {
        return this.retrieve(request, name, profile, null, path, resolvePlaceholders, acceptedCharset);
    }

    private String getFilePath(ServletWebRequest request, String name, String profile, String label) {
        String stem = label != null ? String.format("/%s/%s/%s/", name, profile, label) : String.format("/%s/%s/", name, profile);
        String path = this.helper.getPathWithinApplication(request.getRequest());
        path = path.substring(path.indexOf(stem) + stem.length());
        return path;
    }

    synchronized String retrieve(ServletWebRequest request, String name, String profile, String label, String path, boolean resolvePlaceholders, String acceptedCharset) throws IOException {
        Resource resource = this.resourceRepository.findOne(name = Environment.normalize((String)name), profile, label = Environment.normalize((String)label), path);
        if (this.checkNotModified(request, resource)) {
            return null;
        }
        try (InputStream is = resource.getInputStream();){
            Charset charset = StandardCharsets.UTF_8;
            try {
                charset = Charset.forName(acceptedCharset);
            }
            catch (UnsupportedCharsetException e) {
                logger.warn((Object)"The accepted charset received from the client is not supported. Using UTF-8 instead.", (Throwable)e);
            }
            String text = StreamUtils.copyToString((InputStream)is, (Charset)charset);
            String ext = StringUtils.getFilenameExtension((String)resource.getFilename());
            if (ext != null) {
                ext = ext.toLowerCase(Locale.ROOT);
            }
            Environment environment = this.environmentRepository.findOne(name, profile, label, false);
            if (resolvePlaceholders) {
                text = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), text);
            }
            if (ext != null && this.encryptEnabled && this.plainTextEncryptEnabled) {
                ResourceEncryptor re = this.resourceEncryptorMap.get(ext);
                if (re == null) {
                    logger.warn((Object)("Cannot decrypt for extension " + ext));
                } else {
                    text = re.decrypt(text, environment);
                }
            }
            String string = text;
            return string;
        }
    }

    String retrieve(String name, String profile, String label, String path, boolean resolvePlaceholders, String acceptedCharset) throws IOException {
        return this.retrieve(null, name, profile, label, path, resolvePlaceholders, acceptedCharset);
    }

    @GetMapping(value={"/{name}/{profile}/{label}/**"}, produces={"application/octet-stream"})
    public byte[] binary(@PathVariable String name, @PathVariable String profile, @PathVariable String label, ServletWebRequest request) throws IOException {
        String path = this.getFilePath(request, name, profile, label);
        return this.binary(request, name, profile, label, path);
    }

    @GetMapping(value={"/{name}/{profile}/{path:.*}"}, params={"useDefaultLabel"}, produces={"application/octet-stream"})
    public byte[] binaryDefault(@PathVariable String name, @PathVariable String profile, @PathVariable String path, ServletWebRequest request) throws IOException {
        return this.binary(request, name, profile, null, path);
    }

    byte[] binary(String name, String profile, String label, String path) throws IOException {
        return this.binary(null, name, profile, label, path);
    }

    private synchronized byte[] binary(ServletWebRequest request, String name, String profile, String label, String path) throws IOException {
        Resource resource = this.resourceRepository.findOne(name = Environment.normalize((String)name), profile, label = Environment.normalize((String)label), path);
        if (this.checkNotModified(request, resource)) {
            return null;
        }
        EnvironmentPropertySource.prepareEnvironment(this.environmentRepository.findOne(name, profile, label));
        try (InputStream is = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }

    private boolean checkNotModified(ServletWebRequest request, Resource resource) {
        try {
            return request != null && request.checkNotModified(resource.lastModified());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

