/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.joda.convert.ConstructorFromStringConverter;
import org.joda.convert.FromString;
import org.joda.convert.FromStringFactory;
import org.joda.convert.MethodFromStringConverter;
import org.joda.convert.ReflectionStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ToString;
import org.joda.convert.TypedFromStringConverter;

final class AnnotationStringConverterFactory
implements StringConverterFactory {
    static final AnnotationStringConverterFactory INSTANCE = new AnnotationStringConverterFactory();

    private AnnotationStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        return this.findAnnotatedConverter(cls);
    }

    private <T> StringConverter<T> findAnnotatedConverter(Class<T> cls) {
        Method toString = this.findToStringMethod(cls);
        if (toString == null) {
            return null;
        }
        TypedFromStringConverter<T> fromString = this.findAnnotatedFromStringConverter(cls);
        if (fromString == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString: " + cls.getName());
        }
        return new ReflectionStringConverter<T>(cls, toString, fromString);
    }

    <T> TypedFromStringConverter<T> findFromStringConverter(Class<T> cls) {
        return this.findAnnotatedFromStringConverter(cls);
    }

    private <T> TypedFromStringConverter<T> findAnnotatedFromStringConverter(Class<T> cls) {
        TypedFromStringConverter<T> con = this.findFromStringConstructor(cls);
        TypedFromStringConverter<T> mth = this.findFromStringMethod(cls, con == null);
        if (con != null && mth != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString: " + cls.getName());
        }
        return con != null ? con : mth;
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods;
            Method[] methodArray = methods = loopCls.getDeclaredMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                ToString toString;
                Method method = methodArray[i];
                if (method.isBridge() || method.isSynthetic() || (toString = method.getAnnotation(ToString.class)) == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString: " + cls.getName());
                }
                matched = method;
            }
        }
        if (matched == null) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method[] methods;
                for (Method method : methods = loopIfc.getDeclaredMethods()) {
                    ToString toString;
                    if (method.isBridge() || method.isSynthetic() || (toString = method.getAnnotation(ToString.class)) == null) continue;
                    if (matched != null) {
                        throw new IllegalStateException("Two methods are annotated with @ToString on interfaces: " + cls.getName());
                    }
                    matched = method;
                }
            }
        }
        return matched;
    }

    private <T> TypedFromStringConverter<T> findFromStringConstructor(Class<T> cls) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString = con.getAnnotation(FromString.class);
        if (fromString == null) {
            return null;
        }
        return new ConstructorFromStringConverter<T>(cls, con);
    }

    private <T> TypedFromStringConverter<T> findFromStringMethod(Class<T> cls, boolean searchSuperclasses) {
        for (Class<T> loopCls = cls; loopCls != null; loopCls = loopCls.getSuperclass()) {
            Method fromString = this.findFromString(loopCls);
            if (fromString != null) {
                return new MethodFromStringConverter<T>(cls, fromString, loopCls);
            }
            if (!searchSuperclasses) break;
        }
        MethodFromStringConverter<T> matched = null;
        if (searchSuperclasses) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method fromString = this.findFromString(loopIfc);
                if (fromString == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two different interfaces are annotated with @FromString or @FromStringFactory: " + cls.getName());
                }
                matched = new MethodFromStringConverter<T>(cls, fromString, loopIfc);
            }
        }
        return matched;
    }

    private Method findFromString(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        Method matched = null;
        for (Method method : methods) {
            FromString fromString;
            if (method.isBridge() || method.isSynthetic() || (fromString = method.getAnnotation(FromString.class)) == null) continue;
            if (matched != null) {
                throw new IllegalStateException("Two methods are annotated with @FromString: " + cls.getName());
            }
            matched = method;
        }
        FromStringFactory factory = cls.getAnnotation(FromStringFactory.class);
        if (factory != null) {
            Method[] factoryMethods;
            if (matched != null) {
                throw new IllegalStateException("Class annotated with @FromString and @FromStringFactory: " + cls.getName());
            }
            for (Method method : factoryMethods = factory.factory().getDeclaredMethods()) {
                FromString fromString;
                if (method.isBridge() || method.isSynthetic() || !cls.isAssignableFrom(method.getReturnType()) || (fromString = method.getAnnotation(FromString.class)) == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @FromString on the factory: " + factory.factory().getName());
                }
                matched = method;
            }
        }
        return matched;
    }

    private Class<?> eliminateEnumSubclass(Class<?> cls) {
        Class<?> sup = cls.getSuperclass();
        if (sup != null && sup.getSuperclass() == Enum.class) {
            return sup;
        }
        return cls;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

