/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;

public final class X509Configurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<X509Configurer<H>, H> {
    private X509AuthenticationFilter x509AuthenticationFilter;
    private X509PrincipalExtractor x509PrincipalExtractor;
    private AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> authenticationUserDetailsService;
    private AuthenticationDetailsSource<HttpServletRequest, PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails> authenticationDetailsSource;

    public X509Configurer<H> x509AuthenticationFilter(X509AuthenticationFilter x509AuthenticationFilter) {
        this.x509AuthenticationFilter = x509AuthenticationFilter;
        return this;
    }

    public X509Configurer<H> x509PrincipalExtractor(X509PrincipalExtractor x509PrincipalExtractor) {
        this.x509PrincipalExtractor = x509PrincipalExtractor;
        return this;
    }

    public X509Configurer<H> authenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
        return this;
    }

    public X509Configurer<H> userDetailsService(UserDetailsService userDetailsService) {
        UserDetailsByNameServiceWrapper authenticationUserDetailsService = new UserDetailsByNameServiceWrapper();
        authenticationUserDetailsService.setUserDetailsService(userDetailsService);
        return this.authenticationUserDetailsService((AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken>)authenticationUserDetailsService);
    }

    public X509Configurer<H> authenticationUserDetailsService(AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> authenticationUserDetailsService) {
        this.authenticationUserDetailsService = authenticationUserDetailsService;
        return this;
    }

    public X509Configurer<H> subjectPrincipalRegex(String subjectPrincipalRegex) {
        SubjectDnX509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();
        principalExtractor.setSubjectDnRegex(subjectPrincipalRegex);
        this.x509PrincipalExtractor = principalExtractor;
        return this;
    }

    @Override
    public void init(H http) {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService(this.getAuthenticationUserDetailsService(http));
        http.authenticationProvider((AuthenticationProvider)authenticationProvider).setSharedObject(AuthenticationEntryPoint.class, (Http403ForbiddenEntryPoint)new Http403ForbiddenEntryPoint());
    }

    @Override
    public void configure(H http) {
        X509AuthenticationFilter filter = this.getFilter(http.getSharedObject(AuthenticationManager.class), http);
        http.addFilter((Filter)filter);
    }

    private X509AuthenticationFilter getFilter(AuthenticationManager authenticationManager, H http) {
        if (this.x509AuthenticationFilter == null) {
            this.x509AuthenticationFilter = new X509AuthenticationFilter();
            this.x509AuthenticationFilter.setAuthenticationManager(authenticationManager);
            if (this.x509PrincipalExtractor != null) {
                this.x509AuthenticationFilter.setPrincipalExtractor(this.x509PrincipalExtractor);
            }
            if (this.authenticationDetailsSource != null) {
                this.x509AuthenticationFilter.setAuthenticationDetailsSource(this.authenticationDetailsSource);
            }
            this.x509AuthenticationFilter.setSecurityContextRepository((SecurityContextRepository)new RequestAttributeSecurityContextRepository());
            this.x509AuthenticationFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
            this.x509AuthenticationFilter = this.postProcess(this.x509AuthenticationFilter);
        }
        return this.x509AuthenticationFilter;
    }

    private AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> getAuthenticationUserDetailsService(H http) {
        if (this.authenticationUserDetailsService == null) {
            this.userDetailsService(this.getSharedOrBean(http, UserDetailsService.class));
        }
        return this.authenticationUserDetailsService;
    }

    private <C> C getSharedOrBean(H http, Class<C> type) {
        C shared = http.getSharedObject(type);
        if (shared != null) {
            return shared;
        }
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        return (C)context.getBeanProvider(type).getIfUnique();
    }
}

