/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.method.configuration.DeferringMethodInterceptor;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(value="_securedMethodSecurityConfiguration", proxyBeanMethods=false)
@Role(value=2)
final class SecuredMethodSecurityConfiguration
implements ImportAware,
AopInfrastructureBean {
    private static final Pointcut pointcut = AuthorizationManagerBeforeMethodInterceptor.secured().getPointcut();
    private final SecuredAuthorizationManager authorizationManager = new SecuredAuthorizationManager();
    private final AuthorizationManagerBeforeMethodInterceptor methodInterceptor;

    SecuredMethodSecurityConfiguration(ObjectProvider<ObjectPostProcessor<AuthorizationManager<MethodInvocation>>> postProcessors) {
        ObjectPostProcessor postProcessor = (ObjectPostProcessor)postProcessors.getIfUnique(ObjectPostProcessor::identity);
        AuthorizationManager manager = (AuthorizationManager)postProcessor.postProcess(this.authorizationManager);
        this.methodInterceptor = AuthorizationManagerBeforeMethodInterceptor.secured((AuthorizationManager)manager);
    }

    @Bean
    @Role(value=2)
    static MethodInterceptor securedAuthorizationMethodInterceptor(ObjectProvider<SecuredMethodSecurityConfiguration> securedMethodSecurityConfiguration) {
        Supplier<AuthorizationManagerBeforeMethodInterceptor> supplier = () -> {
            SecuredMethodSecurityConfiguration configuration = (SecuredMethodSecurityConfiguration)securedMethodSecurityConfiguration.getObject();
            return configuration.methodInterceptor;
        };
        return new DeferringMethodInterceptor<AuthorizationManagerBeforeMethodInterceptor>(pointcut, supplier);
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        this.methodInterceptor.setOrder(this.methodInterceptor.getOrder() + annotation.offset());
    }

    @Autowired(required=false)
    void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        AuthoritiesAuthorizationManager authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
        authoritiesAuthorizationManager.setRoleHierarchy(roleHierarchy);
        this.authorizationManager.setAuthoritiesAuthorizationManager((AuthorizationManager)authoritiesAuthorizationManager);
    }

    @Autowired(required=false)
    void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        this.methodInterceptor.setSecurityContextHolderStrategy(securityContextHolderStrategy);
    }

    @Autowired(required=false)
    void setEventPublisher(AuthorizationEventPublisher eventPublisher) {
        this.methodInterceptor.setAuthorizationEventPublisher(eventPublisher);
    }
}

