/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.DefaultTextEncryptionAutoConfiguration;
import org.springframework.cloud.config.server.encryption.CipherEnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.encryption.SingleTextEncryptorLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={DefaultTextEncryptionAutoConfiguration.class})
public class EncryptionAutoConfiguration {
    @Value(value="${spring.cloud.config.server.encrypt.prefixInvalidProperties:${spring.cloud.config.server.encrypt.prefix-invalid-properties:true}}")
    private boolean prefixInvalidProperties;

    @Bean
    @ConditionalOnBean(value={TextEncryptor.class})
    @ConditionalOnMissingBean(value={TextEncryptorLocator.class})
    public SingleTextEncryptorLocator singleTextEncryptorLocator(TextEncryptor encryptor) {
        return new SingleTextEncryptorLocator(encryptor);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.config.server.encrypt.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={TextEncryptorLocator.class})
    public EnvironmentEncryptor environmentEncryptor(@Autowired(required=false) TextEncryptorLocator locator, TextEncryptor encryptor) {
        if (locator == null) {
            locator = new SingleTextEncryptorLocator(encryptor);
        }
        CipherEnvironmentEncryptor environmentEncryptor = new CipherEnvironmentEncryptor(locator);
        environmentEncryptor.setPrefixInvalidProperties(this.prefixInvalidProperties);
        return environmentEncryptor;
    }
}

