/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;

public class AgeFileFilter
implements FileFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean acceptOlder;
    private final long cutoff;

    private static boolean isFileNewer(FileObject fileObject, long timeMillis) throws FileSystemException {
        Objects.requireNonNull(fileObject, "fileObject");
        if (!fileObject.exists()) {
            return false;
        }
        try (FileContent content = fileObject.getContent();){
            boolean bl = content.getLastModifiedTime() > timeMillis;
            return bl;
        }
    }

    public AgeFileFilter(Date cutoffDate) {
        this(cutoffDate, true);
    }

    public AgeFileFilter(Date cutoffDate, boolean acceptOlder) {
        this(cutoffDate.getTime(), acceptOlder);
    }

    public AgeFileFilter(FileObject cutoffReference) throws FileSystemException {
        this(cutoffReference, true);
    }

    public AgeFileFilter(FileObject cutoffReference, boolean acceptOlder) throws FileSystemException {
        this(cutoffReference.getContent().getLastModifiedTime(), acceptOlder);
    }

    public AgeFileFilter(long cutoff) {
        this(cutoff, true);
    }

    public AgeFileFilter(long cutoff, boolean acceptOlder) {
        this.acceptOlder = acceptOlder;
        this.cutoff = cutoff;
    }

    @Override
    public boolean accept(FileSelectInfo fileInfo) throws FileSystemException {
        return this.acceptOlder != AgeFileFilter.isFileNewer(fileInfo.getFile(), this.cutoff);
    }

    public String toString() {
        String condition = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + condition + this.cutoff + ")";
    }
}

