/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.url;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.url.UrlFileSystem;

public class UrlFileObject
extends AbstractFileObject<UrlFileSystem> {
    private URL url;

    protected UrlFileObject(UrlFileSystem fileSystem, AbstractFileName fileName) {
        super(fileName, fileSystem);
    }

    protected URL createURL(FileName name) throws IOException {
        if (name instanceof URLFileName) {
            URLFileName urlName = (URLFileName)this.getName();
            return new URL(urlName.getURIEncoded(null));
        }
        return new URL(this.getName().getURI());
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.url == null) {
            this.url = this.createURL(this.getName());
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        URLConnection conn = this.url.openConnection();
        try (InputStream unused = conn.getInputStream();){
            long l = conn.getContentLength();
            return l;
        }
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return this.url.openStream();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        URLConnection conn = this.url.openConnection();
        try (InputStream unused = conn.getInputStream();){
            long l = conn.getLastModified();
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected FileType doGetType() throws Exception {
        try {
            URLConnection conn = this.url.openConnection();
            try (InputStream unused = conn.getInputStream();){
                int status;
                if (conn instanceof HttpURLConnection && 200 != (status = ((HttpURLConnection)conn).getResponseCode())) {
                    FileType fileType2 = FileType.IMAGINARY;
                    return fileType2;
                }
                FileType fileType = FileType.FILE;
                return fileType;
            }
        }
        catch (FileNotFoundException e) {
            return FileType.IMAGINARY;
        }
    }

    @Override
    protected String[] doListChildren() throws Exception {
        throw new FileSystemException("Not implemented.");
    }
}

