/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.util.Cryptor;
import org.apache.commons.vfs2.util.CryptorFactory;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;

    private static boolean isHostNameTerminatingChar(char ch, boolean isIPv6Host) {
        if (isIPv6Host) {
            return ch == ']';
        }
        return ch == '/' || ch == ';' || ch == '?' || ch == ':' || ch == '@' || ch == '&' || ch == '=' || ch == '+' || ch == '$' || ch == ',';
    }

    private static boolean isIPv6Host(String name) {
        return name.length() > 0 && HostFileNameParser.isIPv6HostHeadingChar(name.charAt(0));
    }

    private static boolean isIPv6HostHeadingChar(char ch) {
        return ch == '[';
    }

    public HostFileNameParser(int defaultPort) {
        this.defaultPort = defaultPort;
    }

    protected String extractHostName(StringBuilder name) {
        char ch;
        int pos;
        int maxlen = name.length();
        boolean isIPv6Host = HostFileNameParser.isIPv6Host(name.toString());
        for (pos = 0; pos < maxlen && !HostFileNameParser.isHostNameTerminatingChar(ch = name.charAt(pos), isIPv6Host); ++pos) {
        }
        if (pos == 0) {
            return null;
        }
        if (isIPv6Host && pos < maxlen) {
            if (pos == 1) {
                return null;
            }
            ++pos;
        }
        String hostname = name.substring(0, pos);
        name.delete(0, pos);
        return hostname;
    }

    protected int extractPort(StringBuilder name, String uri) throws FileSystemException {
        char ch;
        int pos;
        if (name.length() < 1 || name.charAt(0) != ':') {
            return -1;
        }
        int maxlen = name.length();
        for (pos = 1; pos < maxlen && (ch = name.charAt(pos)) >= '0' && ch <= '9'; ++pos) {
        }
        String port = name.substring(1, pos);
        name.delete(0, pos);
        if (port.isEmpty()) {
            throw new FileSystemException("vfs.provider/missing-port.error", (Object)uri);
        }
        return Integer.parseInt(port);
    }

    @Deprecated
    protected Authority extractToPath(String uri, StringBuilder name) throws FileSystemException {
        return this.extractToPath(null, uri, name);
    }

    protected Authority extractToPath(VfsComponentContext context, String uri, StringBuilder name) throws FileSystemException {
        String hostName;
        String password;
        String userName;
        Authority auth = new Authority();
        FileSystemManager fsm = context != null ? context.getFileSystemManager() : VFS.getManager();
        auth.scheme = UriParser.extractScheme(fsm.getSchemes(), uri, name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)uri);
        }
        name.delete(0, 2);
        String userInfo = this.extractUserInfo(name);
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                userName = userInfo;
                password = null;
            } else {
                userName = userInfo.substring(0, idx);
                password = userInfo.substring(idx + 1);
            }
        } else {
            userName = null;
            password = null;
        }
        auth.userName = UriParser.decode(userName);
        auth.password = UriParser.decode(password);
        if (auth.password != null && auth.password.startsWith("{") && auth.password.endsWith("}")) {
            try {
                Cryptor cryptor = CryptorFactory.getCryptor();
                auth.password = cryptor.decrypt(auth.password.substring(1, auth.password.length() - 1));
            }
            catch (Exception ex) {
                throw new FileSystemException("Unable to decrypt password", ex);
            }
        }
        if ((hostName = this.extractHostName(name)) == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", (Object)uri);
        }
        if (HostFileNameParser.isIPv6Host(hostName) && !HostFileNameParser.isHostNameTerminatingChar(hostName.charAt(hostName.length() - 1), true)) {
            throw new FileSystemException("vfs.provider/unterminated-ipv6-hostname.error", (Object)uri);
        }
        auth.hostName = hostName.toLowerCase();
        auth.port = this.extractPort(name, uri);
        if (name.length() > 0 && name.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", (Object)uri);
        }
        return auth;
    }

    protected String extractUserInfo(StringBuilder name) {
        int maxlen = name.length();
        for (int pos = 0; pos < maxlen; ++pos) {
            char ch = name.charAt(pos);
            if (ch == '@') {
                String userInfo = name.substring(0, pos);
                name.delete(0, pos + 1);
                return userInfo;
            }
            if (ch == '/' || ch == '?') break;
        }
        return null;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String fileName) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        Authority auth = this.extractToPath(context, fileName, name);
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new GenericFileName(auth.scheme, auth.hostName, auth.port, this.defaultPort, auth.userName, auth.password, path, fileType);
    }

    protected static class Authority {
        private String hostName;
        private String password;
        private int port;
        private String scheme;
        private String userName;

        public String getHostName() {
            return this.hostName;
        }

        public String getPassword() {
            return this.password;
        }

        public int getPort() {
            return this.port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }
    }
}

