/*
 * Decompiled with CFR 0.152.
 */
package com.samskivert.mustache;

import com.samskivert.mustache.DefaultCollector;
import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.MustacheException;
import com.samskivert.mustache.MustacheParseException;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Mustache {
    protected static final int TEXT = 0;
    protected static final int MATCHING_START = 1;
    protected static final int MATCHING_END = 2;
    protected static final int TAG = 3;
    protected static final char NO_CHAR = '\u0000';
    protected static final TemplateLoader FAILING_LOADER = new TemplateLoader(){

        @Override
        public Reader getTemplate(String name) {
            throw new UnsupportedOperationException("Template loading not configured");
        }
    };
    protected static final Formatter DEFAULT_FORMATTER = new Formatter(){

        @Override
        public String format(Object value) {
            return String.valueOf(value);
        }
    };

    public static Compiler compiler() {
        return new Compiler(false, false, null, false, false, false, DEFAULT_FORMATTER, Escapers.HTML, FAILING_LOADER, new DefaultCollector(), new Delims());
    }

    protected static Template compile(Reader source, Compiler compiler) {
        Accumulator accum = new Parser(compiler).parse(source);
        return new Template(Mustache.trim(accum.finish(), true), compiler);
    }

    private Mustache() {
    }

    protected static Template.Segment[] trim(Template.Segment[] segs, boolean top) {
        int ll = segs.length;
        for (int ii = 0; ii < ll; ++ii) {
            String indent;
            boolean nextBlank;
            Template.Segment seg = segs[ii];
            Template.Segment pseg = ii > 0 ? segs[ii - 1] : null;
            Template.Segment nseg = ii < ll - 1 ? segs[ii + 1] : null;
            StringSegment prev = pseg instanceof StringSegment ? (StringSegment)pseg : null;
            StringSegment next = nseg instanceof StringSegment ? (StringSegment)nseg : null;
            boolean prevBlank = pseg == null && top || prev != null && prev.trailsBlank();
            boolean bl = nextBlank = nseg == null && top || next != null && next.leadsBlank();
            if (seg instanceof StandaloneSection) {
                StandaloneSection sect = (StandaloneSection)((Object)seg);
                indent = "";
                if (prevBlank && sect.firstLeadsBlank()) {
                    if (prev != null) {
                        indent = prev.indent();
                        segs[ii - 1] = prev.trimTrailBlank();
                    }
                    sect.trimFirstBlank();
                    sect.standaloneStart(true);
                }
                if (nextBlank && sect.lastTrailsBlank()) {
                    sect.trimLastBlank();
                    if (next != null) {
                        segs[ii + 1] = next.trimLeadBlank();
                    }
                    sect.standaloneEnd(true);
                }
                if (!(sect instanceof ParentTemplateSegment) || indent.equals("")) continue;
                ParentTemplateSegment pt = (ParentTemplateSegment)sect;
                segs[ii] = pt.indent(indent, pseg == null, nseg == null);
                continue;
            }
            if (seg instanceof IncludedTemplateSegment) {
                IncludedTemplateSegment include = (IncludedTemplateSegment)seg;
                if (prev == null || !prevBlank || !nextBlank) continue;
                indent = prev.indent();
                include._standalone = true;
                if (!indent.equals("")) {
                    include = include.indent(indent, pseg == null, nseg == null);
                    segs[ii] = include;
                }
                if (next == null) continue;
                segs[ii + 1] = next.trimLeadBlank();
                continue;
            }
            if (!(seg instanceof FauxSegment) || !prevBlank || !nextBlank) continue;
            if (pseg != null) {
                segs[ii - 1] = prev.trimTrailBlank();
            }
            if (nseg == null) continue;
            segs[ii + 1] = next.trimLeadBlank();
        }
        return segs;
    }

    static Template.Segment[] indentSegs(Template.Segment[] _segs, String indent, boolean _first, boolean _last) {
        if (indent.equals("")) {
            return _segs;
        }
        int length = _segs.length;
        Template.Segment[] copySegs = new Template.Segment[length];
        boolean changed = false;
        for (int i = 0; i < _segs.length; ++i) {
            Template.Segment copy;
            Template.Segment nseg;
            Template.Segment seg = _segs[i];
            Template.Segment pseg = i > 0 ? _segs[i - 1] : null;
            Template.Segment segment = nseg = i < length - 1 ? _segs[i + 1] : null;
            if (seg instanceof AbstractSectionSegment) {
                AbstractSectionSegment bs = (AbstractSectionSegment)seg;
                boolean first = pseg == null ? _first : bs.isStandaloneStart();
                boolean last = bs.isStandalone() ? false : (nseg == null ? _last : true);
                copy = bs.indent(indent, first, last);
            } else if (seg instanceof StringSegment) {
                AbstractSectionSegment bs;
                boolean first = pseg == null ? _first : pseg.isStandalone();
                boolean last = nseg == null ? _last : (nseg instanceof AbstractSectionSegment ? !(bs = (AbstractSectionSegment)nseg).isStandaloneStart() : !nseg.isStandalone());
                copy = seg.indent(indent, first, last);
            } else if (seg instanceof IncludedTemplateSegment) {
                if (seg.isStandalone()) {
                    boolean last = nseg == null ? _last : !nseg.isStandalone();
                    copy = seg.indent(indent, false, last);
                } else {
                    copy = seg;
                }
            } else {
                copy = seg.indent(indent, _first, _last);
            }
            if (copy != seg) {
                changed = true;
            }
            copySegs[i] = copy;
        }
        if (changed) {
            return copySegs;
        }
        return _segs;
    }

    static Template.Segment[] replaceBlockSegs(Template.Segment[] _segs, Map<String, BlockSegment> blocks) {
        if (blocks.isEmpty()) {
            return _segs;
        }
        int length = _segs.length;
        Template.Segment[] copySegs = new Template.Segment[length];
        boolean changed = false;
        for (int i = 0; i < _segs.length; ++i) {
            Template.Segment copy;
            Template.Segment seg = _segs[i];
            if (seg instanceof BlockReplaceable) {
                BlockReplaceable br = (BlockReplaceable)((Object)seg);
                copy = br.replaceBlocks(blocks);
            } else {
                copy = seg;
            }
            if (copy != seg) {
                changed = true;
            }
            copySegs[i] = copy;
        }
        if (changed) {
            return copySegs;
        }
        return _segs;
    }

    protected static void restoreStartTag(StringBuilder text, Delims starts) {
        text.insert(0, starts.start1);
        if (starts.start2 != '\u0000') {
            text.insert(1, starts.start2);
        }
    }

    protected static boolean allowsWhitespace(char typeChar) {
        return typeChar == '=' || typeChar == '!';
    }

    public static class Compiler {
        public final boolean standardsMode;
        public final boolean strictSections;
        public final String nullValue;
        public final boolean missingIsNull;
        public final boolean emptyStringIsFalse;
        public final boolean zeroIsFalse;
        public final Formatter formatter;
        public final Escaper escaper;
        public final TemplateLoader loader;
        public final Collector collector;
        public final Delims delims;

        public Template compile(String template) {
            return this.compile(new StringReader(template));
        }

        public Template compile(Reader source) {
            return Mustache.compile(source, this);
        }

        public Compiler escapeHTML(boolean escapeHTML) {
            return this.withEscaper(escapeHTML ? Escapers.HTML : Escapers.NONE);
        }

        public Compiler standardsMode(boolean standardsMode) {
            return new Compiler(standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler strictSections(boolean strictSections) {
            return new Compiler(this.standardsMode, strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler defaultValue(String defaultValue) {
            return new Compiler(this.standardsMode, this.strictSections, defaultValue, true, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler nullValue(String nullValue) {
            return new Compiler(this.standardsMode, this.strictSections, nullValue, false, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler emptyStringIsFalse(boolean emptyStringIsFalse) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler zeroIsFalse(boolean zeroIsFalse) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withFormatter(Formatter formatter) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, formatter, this.escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withEscaper(Escaper escaper) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, escaper, this.loader, this.collector, this.delims);
        }

        public Compiler withLoader(TemplateLoader loader) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, loader, this.collector, this.delims);
        }

        public Compiler withCollector(Collector collector) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, collector, this.delims);
        }

        public Compiler withDelims(String delims) {
            return new Compiler(this.standardsMode, this.strictSections, this.nullValue, this.missingIsNull, this.emptyStringIsFalse, this.zeroIsFalse, this.formatter, this.escaper, this.loader, this.collector, new Delims().updateDelims(delims));
        }

        public String computeNullValue(String name) {
            return this.nullValue == null ? null : this.nullValue.replace("{{name}}", name);
        }

        public boolean isFalsey(Object value) {
            return this.emptyStringIsFalse && this.isEmptyCharSequence(this.formatter.format(value)) || this.zeroIsFalse && value instanceof Number && ((Number)value).longValue() == 0L;
        }

        private boolean isEmptyCharSequence(Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof CharSequence) {
                return ((CharSequence)value).length() == 0;
            }
            return false;
        }

        public Template loadTemplate(String name) throws MustacheException {
            Reader tin = null;
            try {
                tin = this.loader.getTemplate(name);
                Template template = this.compile(tin);
                return template;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MustacheException("Unable to load template: " + name, e);
            }
            finally {
                if (tin != null) {
                    try {
                        tin.close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }

        protected Compiler(boolean standardsMode, boolean strictSections, String nullValue, boolean missingIsNull, boolean emptyStringIsFalse, boolean zeroIsFalse, Formatter formatter, Escaper escaper, TemplateLoader loader, Collector collector, Delims delims) {
            this.standardsMode = standardsMode;
            this.strictSections = strictSections;
            this.nullValue = nullValue;
            this.missingIsNull = missingIsNull;
            this.emptyStringIsFalse = emptyStringIsFalse;
            this.zeroIsFalse = zeroIsFalse;
            this.formatter = formatter;
            this.escaper = escaper;
            this.loader = loader;
            this.collector = collector;
            this.delims = delims;
        }
    }

    public static interface Formatter {
        public CharSequence format(Object var1);
    }

    public static interface Escaper {
        public String escape(String var1);

        default public CharSequence escape(CharSequence raw) {
            return this.escape(raw.toString());
        }
    }

    public static interface TemplateLoader {
        public Reader getTemplate(String var1) throws Exception;
    }

    protected static class Delims {
        public char start1 = (char)123;
        public char end1 = (char)125;
        public char start2 = (char)123;
        public char end2 = (char)125;

        protected Delims() {
        }

        public boolean isStaches() {
            return this.start1 == '{' && this.start2 == '{' && this.end1 == '}' && this.end2 == '}';
        }

        public Delims updateDelims(String dtext) {
            String[] delims = dtext.split(" ");
            if (delims.length != 2) {
                throw new MustacheException(Delims.errmsg(dtext));
            }
            switch (delims[0].length()) {
                case 1: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = '\u0000';
                    break;
                }
                case 2: {
                    this.start1 = delims[0].charAt(0);
                    this.start2 = delims[0].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(Delims.errmsg(dtext));
                }
            }
            switch (delims[1].length()) {
                case 1: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = '\u0000';
                    break;
                }
                case 2: {
                    this.end1 = delims[1].charAt(0);
                    this.end2 = delims[1].charAt(1);
                    break;
                }
                default: {
                    throw new MustacheException(Delims.errmsg(dtext));
                }
            }
            return this;
        }

        public void addTag(char prefix, String name, StringBuilder into) {
            into.append(this.start1);
            into.append(this.start2);
            if (prefix != ' ') {
                into.append(prefix);
            }
            into.append(name);
            into.append(this.end1);
            into.append(this.end2);
        }

        Delims copy() {
            Delims d = new Delims();
            d.start1 = this.start1;
            d.start2 = this.start2;
            d.end1 = this.end1;
            d.end2 = this.end2;
            return d;
        }

        private static String errmsg(String dtext) {
            return "Invalid delimiter configuration '" + dtext + "'. Must be of the form {{=1 2=}} or {{=12 34=}} where 1, 2, 3 and 4 are delimiter chars.";
        }
    }

    public static interface Collector {
        public Iterator<?> toIterator(Object var1);

        public VariableFetcher createFetcher(Object var1, String var2);

        public <K, V> Map<K, V> createFetcherCache();
    }

    protected static class Parser {
        final Delims delims;
        final StringBuilder text = new StringBuilder();
        Reader source;
        Accumulator accum;
        int state = 0;
        int line = 1;
        int column = 0;
        int tagStartColumn = -1;

        public Parser(Compiler compiler) {
            this.accum = new Accumulator(compiler, true);
            this.delims = compiler.delims.copy();
        }

        public Accumulator parse(Reader source) {
            int v;
            this.source = source;
            while ((v = this.nextChar()) != -1) {
                char c = (char)v;
                ++this.column;
                this.parseChar(c);
                if (c != '\n') continue;
                this.column = 0;
                ++this.line;
            }
            switch (this.state) {
                case 3: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    break;
                }
                case 2: {
                    Mustache.restoreStartTag(this.text, this.delims);
                    this.text.append(this.delims.end1);
                    break;
                }
                case 1: {
                    this.text.append(this.delims.start1);
                    break;
                }
            }
            this.accum.addTextSegment(this.text);
            return this.accum;
        }

        protected void parseChar(char c) {
            switch (this.state) {
                case 0: {
                    if (c == this.delims.start1) {
                        this.state = 1;
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 1: {
                    if (c == this.delims.start2) {
                        this.accum.addTextSegment(this.text);
                        this.state = 3;
                        break;
                    }
                    this.text.append(this.delims.start1);
                    this.state = 0;
                    this.parseChar(c);
                    break;
                }
                case 3: {
                    if (c == this.delims.end1) {
                        this.state = 2;
                        if (this.delims.end2 != '\u0000') break;
                        this.parseChar('\u0000');
                        break;
                    }
                    if (c == this.delims.start1 && this.text.length() > 0 && this.text.charAt(0) != '!') {
                        Mustache.restoreStartTag(this.text, this.delims);
                        this.accum.addTextSegment(this.text);
                        this.tagStartColumn = this.column;
                        if (this.delims.start2 == '\u0000') {
                            this.accum.addTextSegment(this.text);
                            this.state = 3;
                            break;
                        }
                        this.state = 1;
                        break;
                    }
                    this.text.append(c);
                    break;
                }
                case 2: {
                    if (c == this.delims.end2) {
                        if (this.text.charAt(0) == '=') {
                            this.delims.updateDelims(this.text.substring(1, this.text.length() - 1));
                            this.text.setLength(0);
                            this.accum.addFauxSegment();
                        } else {
                            if (this.delims.isStaches() && this.text.charAt(0) == this.delims.start1) {
                                int end3 = this.nextChar();
                                if (end3 != 125) {
                                    String got = end3 == -1 ? "" : String.valueOf((char)end3);
                                    throw new MustacheParseException("Invalid triple-mustache tag: {{" + String.valueOf(this.text) + "}}" + got, this.line);
                                }
                                this.text.replace(0, 1, "&");
                            }
                            this.accum = this.accum.addTagSegment(this.text, this.line);
                        }
                        this.state = 0;
                        break;
                    }
                    this.text.append(this.delims.end1);
                    this.state = 3;
                    this.parseChar(c);
                }
            }
        }

        protected int nextChar() {
            try {
                return this.source.read();
            }
            catch (IOException ioe) {
                throw new MustacheException(ioe);
            }
        }
    }

    protected static class Accumulator {
        protected final Compiler _comp;
        protected final boolean _topLevel;
        protected final List<Template.Segment> _segs = new ArrayList<Template.Segment>();

        public Accumulator(Compiler compiler, boolean topLevel) {
            this._comp = compiler;
            this._topLevel = topLevel;
        }

        public void addTextSegment(StringBuilder text) {
            if (text.length() > 0) {
                this._segs.add(new StringSegment(text.toString(), this._segs.isEmpty() && this._topLevel));
                text.setLength(0);
            }
        }

        public Accumulator addTagSegment(StringBuilder accum, final int tagLine) {
            final Accumulator outer = this;
            String tag = accum.toString().trim();
            final String tag1 = tag.substring(1).trim();
            accum.setLength(0);
            switch (tag.charAt(0)) {
                case '#': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Section missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            1.requireSameName(tag1, itag, line);
                            outer._segs.add(new SectionSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '>': {
                    this._segs.add(new IncludedTemplateSegment(this._comp, tag1, tagLine));
                    return this;
                }
                case '<': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Parent missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            2.requireSameName(tag1, itag, line);
                            outer._segs.add(new ParentTemplateSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '$': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Block missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            3.requireSameName(tag1, itag, line);
                            outer._segs.add(new BlockSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '^': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return new Accumulator(this._comp, false){

                        @Override
                        public Template.Segment[] finish() {
                            throw new MustacheParseException("Inverted section missing close tag '" + tag1 + "'", tagLine);
                        }

                        @Override
                        protected Accumulator addCloseSectionSegment(String itag, int line) {
                            4.requireSameName(tag1, itag, line);
                            outer._segs.add(new InvertedSegment(this._comp, itag, super.finish(), tagLine));
                            return outer;
                        }
                    };
                }
                case '/': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    return this.addCloseSectionSegment(tag1, tagLine);
                }
                case '!': {
                    this._segs.add(new FauxSegment());
                    return this;
                }
                case '&': {
                    Accumulator.requireNoNewlines(tag, tagLine);
                    this._segs.add(new VariableSegment(tag1, tagLine, this._comp.formatter, Escapers.NONE));
                    return this;
                }
            }
            Accumulator.requireNoNewlines(tag, tagLine);
            this._segs.add(new VariableSegment(tag, tagLine, this._comp.formatter, this._comp.escaper));
            return this;
        }

        public void addFauxSegment() {
            this._segs.add(new FauxSegment());
        }

        public Template.Segment[] finish() {
            return this._segs.toArray(new Template.Segment[this._segs.size()]);
        }

        protected Accumulator addCloseSectionSegment(String tag, int line) {
            throw new MustacheParseException("Section close tag with no open tag '" + tag + "'", line);
        }

        protected static void requireNoNewlines(String tag, int line) {
            if (tag.indexOf(10) != -1 || tag.indexOf(13) != -1) {
                throw new MustacheParseException("Invalid tag name: contains newline '" + tag + "'", line);
            }
        }

        protected static void requireSameName(String name1, String name2, int line) {
            if (!name1.equals(name2)) {
                throw new MustacheParseException("Section close tag with mismatched open tag '" + name2 + "' != '" + name1 + "'", line);
            }
        }
    }

    protected static class StringSegment
    extends Template.Segment {
        protected final String _text;
        protected final int _leadBlank;
        protected final int _trailBlank;
        protected final boolean _first;

        public StringSegment(String text, boolean first) {
            this(text, StringSegment.blankPos(text, true, first), StringSegment.blankPos(text, false, first), first);
        }

        public StringSegment(String text, int leadBlank, int trailBlank, boolean first) {
            assert (leadBlank >= -1);
            assert (trailBlank >= -1);
            this._text = text;
            this._leadBlank = leadBlank;
            this._trailBlank = trailBlank;
            this._first = first;
        }

        public boolean leadsBlank() {
            return this._leadBlank != -1;
        }

        public boolean trailsBlank() {
            return this._trailBlank != -1;
        }

        public StringSegment trimLeadBlank() {
            if (this._leadBlank == -1) {
                return this;
            }
            int lpos = this._leadBlank + 1;
            int newTrail = this._trailBlank == -1 ? -1 : this._trailBlank - lpos;
            return new StringSegment(this._text.substring(lpos), -1, newTrail, this._first);
        }

        public StringSegment trimTrailBlank() {
            return this._trailBlank == -1 ? this : new StringSegment(this._text.substring(0, this._trailBlank), this._leadBlank, -1, this._first);
        }

        String indent() {
            if (this._trailBlank == -1 || this._trailBlank >= this._text.length()) {
                return "";
            }
            return this._text.substring(this._trailBlank);
        }

        @Override
        StringSegment indent(String indent, boolean first, boolean last) {
            if (indent.equals("")) {
                return this;
            }
            String reindent = StringSegment.reindent(this._text, indent, first, last);
            return new StringSegment(reindent, this._first);
        }

        @Override
        boolean isStandalone() {
            return false;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            StringSegment.write(out, this._text);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            into.append(this._text);
        }

        @Override
        public void visit(Visitor visitor) {
            visitor.visitText(this._text);
        }

        public String toString() {
            return "Text(" + this._text.replace("\r", "\\r").replace("\n", "\\n") + ")" + this._leadBlank + "/" + this._trailBlank;
        }

        private static String reindent(String input, String indent, boolean first, boolean last) {
            int length = input.length();
            StringBuilder sb = new StringBuilder(indent.length() + length);
            if (first) {
                sb.append(indent);
            }
            for (int ii = 0; ii < length; ++ii) {
                char c = input.charAt(ii);
                sb.append(c);
                if (c != '\n' || !last && ii == length - 1) continue;
                sb.append(indent);
            }
            return sb.toString();
        }

        private static int blankPos(String text, boolean leading, boolean first) {
            int dd;
            int len = text.length();
            int ll = leading ? len : -1;
            int n = dd = leading ? 1 : -1;
            for (int ii = leading ? 0 : len - 1; ii != ll; ii += dd) {
                char c = text.charAt(ii);
                if (c == '\n') {
                    return leading ? ii : ii + 1;
                }
                if (Character.isWhitespace(c)) continue;
                return -1;
            }
            return leading || !first ? -1 : 0;
        }
    }

    protected static interface StandaloneSection
    extends BlockReplaceable {
        default public boolean firstLeadsBlank() {
            Template.Segment[] _segs = this._segs();
            if (_segs.length == 0 || !(_segs[0] instanceof StringSegment)) {
                return false;
            }
            return ((StringSegment)_segs[0]).leadsBlank();
        }

        default public void trimFirstBlank() {
            Template.Segment[] _segs = this._segs();
            _segs[0] = ((StringSegment)_segs[0]).trimLeadBlank();
        }

        default public boolean lastTrailsBlank() {
            Template.Segment[] _segs = this._segs();
            int lastIdx = _segs.length - 1;
            if (_segs.length == 0 || !(_segs[lastIdx] instanceof StringSegment)) {
                return false;
            }
            return ((StringSegment)_segs[lastIdx]).trailsBlank();
        }

        default public void trimLastBlank() {
            Template.Segment[] _segs = this._segs();
            int idx = _segs.length - 1;
            _segs[idx] = ((StringSegment)_segs[idx]).trimTrailBlank();
        }

        public boolean isStandaloneEnd();

        public boolean isStandaloneStart();

        public void standaloneStart(boolean var1);

        public void standaloneEnd(boolean var1);

        public Template.Segment[] _segs();
    }

    protected static class ParentTemplateSegment
    extends AbstractPartialSegment
    implements StandaloneSection {
        protected final Template.Segment[] _segs;
        protected boolean _standaloneStart = false;
        protected boolean _standaloneEnd = false;
        protected final Map<String, BlockSegment> _blocks;

        public ParentTemplateSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            this(compiler, name, segs, line, "");
        }

        private ParentTemplateSegment(Compiler compiler, String name, Template.Segment[] segs, int line, String indent) {
            super(compiler, name, line, indent);
            this._segs = Mustache.trim(ParentTemplateSegment.removeNonBlocks(segs), true);
            this._blocks = new LinkedHashMap<String, BlockSegment>();
        }

        private ParentTemplateSegment(ParentTemplateSegment original, Template.Segment[] segs, String indent, Map<String, BlockSegment> blocks) {
            super(original._comp, original._name, original._line, indent + original._indent);
            this._segs = segs;
            this._standaloneStart = original._standaloneStart;
            this._standaloneEnd = original._standaloneEnd;
            LinkedHashMap<String, BlockSegment> newBlocks = new LinkedHashMap<String, BlockSegment>();
            newBlocks.putAll(original._blocks);
            newBlocks.putAll(blocks);
            this._blocks = newBlocks;
        }

        private static Template.Segment[] removeNonBlocks(Template.Segment[] segs) {
            ArrayList<Template.Segment> copy = new ArrayList<Template.Segment>();
            for (Template.Segment seg : segs) {
                if (!(seg instanceof BlockSegment)) continue;
                copy.add(seg);
            }
            return copy.toArray(new Template.Segment[0]);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('<', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitParent(this._name)) {
                this.getTemplate().visit(visitor);
            }
        }

        @Override
        protected ParentTemplateSegment indent(String indent, boolean first, boolean last) {
            if (indent.equals("") || !this._standaloneStart) {
                return this;
            }
            return new ParentTemplateSegment(this, this._segs, indent, Collections.emptyMap());
        }

        @Override
        protected Template _loadTemplate() {
            LinkedHashMap<String, BlockSegment> blocks = new LinkedHashMap<String, BlockSegment>();
            for (Template.Segment seg : this._segs) {
                if (!(seg instanceof BlockSegment)) continue;
                BlockSegment bs = (BlockSegment)seg;
                blocks.put(bs._name, bs);
            }
            blocks.putAll(this._blocks);
            return super._loadTemplate().replaceBlocks(blocks);
        }

        @Override
        public boolean lastTrailsBlank() {
            Template.Segment[] _segs = this._segs();
            int lastIdx = _segs.length - 1;
            if (lastIdx < 0) {
                return true;
            }
            if (!(_segs[lastIdx] instanceof StringSegment)) {
                return false;
            }
            return ((StringSegment)_segs[lastIdx]).trailsBlank();
        }

        @Override
        public void trimLastBlank() {
            Template.Segment[] _segs = this._segs();
            int idx = _segs.length - 1;
            if (idx < 0) {
                return;
            }
            _segs[idx] = ((StringSegment)_segs[idx]).trimTrailBlank();
        }

        @Override
        public ParentTemplateSegment replaceBlocks(Map<String, BlockSegment> blocks) {
            return new ParentTemplateSegment(this, this._segs, "", blocks);
        }

        @Override
        public Template.Segment[] _segs() {
            return this._segs;
        }

        @Override
        public boolean isStandalone() {
            return this._standaloneEnd;
        }

        @Override
        public boolean isStandaloneStart() {
            return this._standaloneStart;
        }

        @Override
        public boolean isStandaloneEnd() {
            return this._standaloneEnd;
        }

        @Override
        public void standaloneStart(boolean standaloneStart) {
            this._standaloneStart = standaloneStart;
        }

        @Override
        public void standaloneEnd(boolean standaloneEnd) {
            this._standaloneEnd = standaloneEnd;
        }

        public String toString() {
            return "Parent(name=" + this._name + ", indent=" + this._indent + ", standaloneStart=" + this._standaloneStart + ")";
        }
    }

    protected static class IncludedTemplateSegment
    extends AbstractPartialSegment {
        protected boolean _standalone;

        public IncludedTemplateSegment(Compiler compiler, String name, int line) {
            this(compiler, name, line, "");
        }

        private IncludedTemplateSegment(Compiler compiler, String name, int line, String indent) {
            super(compiler, name, line, indent);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('<', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitInclude(this._name)) {
                this.getTemplate().visit(visitor);
            }
        }

        @Override
        protected IncludedTemplateSegment indent(String indent, boolean first, boolean last) {
            if (indent.equals("") || !this._standalone) {
                return this;
            }
            IncludedTemplateSegment is = new IncludedTemplateSegment(this._comp, this._name, this._line, indent + this._indent);
            is._standalone = this._standalone;
            return is;
        }

        public String toString() {
            return "Include(name=" + this._name + ", indent=" + this._indent + ", standalone=" + this._standalone + ")";
        }

        @Override
        public boolean isStandalone() {
            return this._standalone;
        }
    }

    protected static class FauxSegment
    extends Template.Segment {
        protected FauxSegment() {
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
        }

        @Override
        public void visit(Visitor visit) {
        }

        @Override
        FauxSegment indent(String indent, boolean first, boolean last) {
            return this;
        }

        @Override
        boolean isStandalone() {
            return true;
        }

        public String toString() {
            return "Faux";
        }
    }

    protected static abstract class AbstractSectionSegment
    extends NamedSegment
    implements StandaloneSection {
        protected final Compiler _comp;
        protected final Template.Segment[] _segs;
        protected boolean _standaloneStart = false;
        protected boolean _standaloneEnd = false;

        protected AbstractSectionSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(name, line);
            this._comp = compiler;
            this._segs = Mustache.trim(segs, false);
        }

        protected AbstractSectionSegment(AbstractSectionSegment original, Template.Segment[] segs) {
            super(original._name, original._line);
            this._comp = original._comp;
            this._segs = segs;
        }

        protected void executeSegs(Template tmpl, Template.Context ctx, Writer out) {
            for (Template.Segment seg : this._segs) {
                seg.execute(tmpl, ctx, out);
            }
        }

        @Override
        protected abstract AbstractSectionSegment indent(String var1, boolean var2, boolean var3);

        @Override
        public boolean isStandalone() {
            return this._standaloneEnd;
        }

        @Override
        public boolean isStandaloneStart() {
            return this._standaloneStart;
        }

        @Override
        public boolean isStandaloneEnd() {
            return this._standaloneEnd;
        }

        @Override
        public void standaloneStart(boolean standaloneStart) {
            this._standaloneStart = standaloneStart;
        }

        @Override
        public void standaloneEnd(boolean standaloneEnd) {
            this._standaloneEnd = standaloneEnd;
        }

        @Override
        public Template.Segment[] _segs() {
            return this._segs;
        }
    }

    protected static interface BlockReplaceable {
        public Template.Segment replaceBlocks(Map<String, BlockSegment> var1);
    }

    protected static class InvertedSegment
    extends AbstractSectionSegment {
        protected final Compiler _comp;

        public InvertedSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(compiler, name, segs, line);
            this._comp = compiler;
        }

        protected InvertedSegment(InvertedSegment original, Template.Segment[] segs) {
            super(original, segs);
            this._comp = original._comp;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            Iterator<?> iter = this._comp.collector.toIterator(value);
            if (iter != null) {
                if (!iter.hasNext()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Boolean) {
                if (!((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof InvertibleLambda) {
                try {
                    ((InvertibleLambda)value).executeInverse(tmpl.createFragment(this._segs, ctx), out);
                }
                catch (IOException ioe) {
                    throw new MustacheException(ioe);
                }
            } else if (this._comp.isFalsey(value)) {
                this.executeSegs(tmpl, ctx, out);
            }
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('^', this._name, into);
            for (Template.Segment seg : this._segs) {
                seg.decompile(delims, into);
            }
            delims.addTag('/', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitInvertedSection(this._name)) {
                for (Template.Segment seg : this._segs) {
                    seg.visit(visitor);
                }
            }
        }

        @Override
        protected InvertedSegment indent(String indent, boolean first, boolean last) {
            Template.Segment[] segs = Mustache.indentSegs(this._segs, indent, first, last);
            if (segs == this._segs) {
                return this;
            }
            return new InvertedSegment(this, segs);
        }

        @Override
        public InvertedSegment replaceBlocks(Map<String, BlockSegment> blocks) {
            Template.Segment[] segs = Mustache.replaceBlockSegs(this._segs, blocks);
            if (segs == this._segs) {
                return this;
            }
            return new InvertedSegment(this, segs);
        }

        public String toString() {
            return "Inverted(" + this._name + ":" + this._line + "): " + Arrays.toString(this._segs);
        }
    }

    protected static class BlockSegment
    extends AbstractSectionSegment {
        public BlockSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(compiler, name, segs, line);
        }

        protected BlockSegment(BlockSegment original, Template.Segment[] segs) {
            super(original, segs);
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            this.executeSegs(tmpl, ctx, out);
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('$', this._name, into);
            for (Template.Segment seg : this._segs) {
                seg.decompile(delims, into);
            }
            delims.addTag('/', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitBlock(this._name)) {
                for (Template.Segment seg : this._segs) {
                    seg.visit(visitor);
                }
            }
        }

        @Override
        protected BlockSegment indent(String indent, boolean first, boolean last) {
            Template.Segment[] segs = Mustache.indentSegs(this._segs, indent, first, last);
            if (segs == this._segs) {
                return this;
            }
            return new BlockSegment(this, segs);
        }

        @Override
        public BlockSegment replaceBlocks(Map<String, BlockSegment> blocks) {
            BlockSegment bs = blocks.get(this._name);
            if (bs == null) {
                Template.Segment[] segs = Mustache.replaceBlockSegs(this._segs, blocks);
                if (segs == this._segs) {
                    return this;
                }
                return new BlockSegment(this, segs);
            }
            return new BlockSegment(this, bs._segs);
        }

        public String toString() {
            return "Block(" + this._name + ":" + this._line + "): " + Arrays.toString(this._segs);
        }
    }

    protected static class SectionSegment
    extends AbstractSectionSegment {
        public SectionSegment(Compiler compiler, String name, Template.Segment[] segs, int line) {
            super(compiler, name, segs, line);
        }

        protected SectionSegment(SectionSegment original, Template.Segment[] segs) {
            super(original, segs);
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getSectionValue(ctx, this._name, this._line);
            Iterator<?> iter = this._comp.collector.toIterator(value);
            if (iter != null) {
                int index = 0;
                while (iter.hasNext()) {
                    Object elem = iter.next();
                    boolean onFirst = index == 0;
                    boolean onLast = !iter.hasNext();
                    this.executeSegs(tmpl, ctx.nest(elem, ++index, onFirst, onLast), out);
                }
            } else if (value instanceof Boolean) {
                if (((Boolean)value).booleanValue()) {
                    this.executeSegs(tmpl, ctx, out);
                }
            } else if (value instanceof Lambda) {
                try {
                    ((Lambda)value).execute(tmpl.createFragment(this._segs, ctx), out);
                }
                catch (IOException ioe) {
                    throw new MustacheException(ioe);
                }
            } else if (!this._comp.isFalsey(value)) {
                this.executeSegs(tmpl, ctx.nest(value), out);
            }
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag('#', this._name, into);
            for (Template.Segment seg : this._segs) {
                seg.decompile(delims, into);
            }
            delims.addTag('/', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            if (visitor.visitSection(this._name)) {
                for (Template.Segment seg : this._segs) {
                    seg.visit(visitor);
                }
            }
        }

        @Override
        protected SectionSegment indent(String indent, boolean first, boolean last) {
            Template.Segment[] segs = Mustache.indentSegs(this._segs, indent, first, last);
            if (segs == this._segs) {
                return this;
            }
            return new SectionSegment(this, segs);
        }

        @Override
        public SectionSegment replaceBlocks(Map<String, BlockSegment> blocks) {
            Template.Segment[] segs = Mustache.replaceBlockSegs(this._segs, blocks);
            if (segs == this._segs) {
                return this;
            }
            return new SectionSegment(this, segs);
        }

        public String toString() {
            return "Section(" + this._name + ":" + this._line + "): " + Arrays.toString(this._segs);
        }
    }

    protected static class VariableSegment
    extends NamedSegment {
        protected final Formatter _formatter;
        protected final Escaper _escaper;

        public VariableSegment(String name, int line, Formatter formatter, Escaper escaper) {
            super(name, line);
            this._formatter = formatter;
            this._escaper = escaper;
        }

        @Override
        public void execute(Template tmpl, Template.Context ctx, Writer out) {
            Object value = tmpl.getValueOrDefault(ctx, this._name, this._line);
            if (value == null) {
                String msg = Template.isThisName(this._name) ? "Resolved '.' to null (which is disallowed), on line " + this._line : "No key, method or field with name '" + this._name + "' on line " + this._line;
                throw new MustacheException.Context(msg, this._name, this._line);
            }
            VariableSegment.write(out, this._escaper.escape(this._formatter.format(value)));
        }

        @Override
        public void decompile(Delims delims, StringBuilder into) {
            delims.addTag(' ', this._name, into);
        }

        @Override
        public void visit(Visitor visitor) {
            visitor.visitVariable(this._name);
        }

        @Override
        VariableSegment indent(String indent, boolean first, boolean last) {
            return this;
        }

        @Override
        boolean isStandalone() {
            return false;
        }

        public String toString() {
            return "Var(" + this._name + ":" + this._line + ")";
        }
    }

    protected static abstract class NamedSegment
    extends Template.Segment {
        protected final String _name;
        protected final int _line;

        protected NamedSegment(String name, int line) {
            this._name = name;
            this._line = line;
        }
    }

    protected static abstract class AbstractPartialSegment
    extends NamedSegment {
        protected final Compiler _comp;
        protected final String _indent;
        private final Lock lock = new ReentrantLock();
        private volatile Template _template;

        protected AbstractPartialSegment(Compiler compiler, String name, int line, String indent) {
            super(name, line);
            this._comp = compiler;
            this._indent = indent;
        }

        @Override
        public final void execute(Template tmpl, Template.Context ctx, Writer out) {
            this.getTemplate().executeSegs(ctx, out);
        }

        protected final Template getTemplate() {
            Template t = this._template;
            if (t == null) {
                this.lock.lock();
                try {
                    t = this._template;
                    if (t == null) {
                        this._template = t = this._loadTemplate();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return t;
        }

        protected Template _loadTemplate() {
            return this._comp.loadTemplate(this._name).indent(this._indent);
        }

        @Override
        public abstract boolean isStandalone();
    }

    public static interface Visitor {
        public void visitText(String var1);

        public void visitVariable(String var1);

        public boolean visitInclude(String var1);

        default public boolean visitParent(String name) {
            return false;
        }

        default public boolean visitBlock(String name) {
            return false;
        }

        public boolean visitSection(String var1);

        public boolean visitInvertedSection(String var1);
    }

    public static interface CustomContext {
        public Object get(String var1) throws Exception;
    }

    public static interface VariableFetcher {
        public Object get(Object var1, String var2) throws Exception;
    }

    public static interface InvertibleLambda
    extends Lambda {
        public void executeInverse(Template.Fragment var1, Writer var2) throws IOException;
    }

    public static interface Lambda {
        public void execute(Template.Fragment var1, Writer var2) throws IOException;
    }
}

