/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.aot;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.server.composite.CompositeEnvironmentBeanFactoryPostProcessor;
import org.springframework.cloud.config.server.composite.CompositeUtils;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.support.EnvironmentRepositoryProperties;
import org.springframework.core.env.Environment;
import org.springframework.javapoet.MethodSpec;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CompositeEnvironmentBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor,
BeanRegistrationExcludeFilter {
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)(ConfigurableListableBeanFactory.class.getSimpleName() + " instance expected."));
        Map<String, BeanDefinition> propertyBeanDefinitions = CompositeEnvironmentBeanFactoryInitializationAotProcessor.getCompositeEnvironmentBeanDefinitions(beanFactory, "-env-repo-properties", EnvironmentRepositoryProperties.class);
        Map<String, BeanDefinition> repoBeanDefinitions = CompositeEnvironmentBeanFactoryInitializationAotProcessor.getCompositeEnvironmentBeanDefinitions(beanFactory, "-env-repo", EnvironmentRepository.class);
        return new CompositeEnvironmentBeanFactoryInitializationAotContribution(propertyBeanDefinitions, repoBeanDefinitions, beanFactory);
    }

    private static Map<String, BeanDefinition> getCompositeEnvironmentBeanDefinitions(ConfigurableListableBeanFactory beanFactory, String infix, Class<?> beanClass) {
        return Arrays.stream(beanFactory.getBeanDefinitionNames()).filter(beanName -> beanName.contains(infix)).map(beanName -> Map.entry(beanName, beanFactory.getBeanDefinition(beanName))).filter(entry -> {
            try {
                return beanClass.isAssignableFrom(Class.forName(((BeanDefinition)entry.getValue()).getBeanClassName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + ((BeanDefinition)entry.getValue()).getBeanClassName() + " could not be found", e);
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
        return CompositeEnvironmentBeanFactoryPostProcessor.class.isAssignableFrom(registeredBean.getBeanClass()) || EnvironmentRepositoryProperties.class.isAssignableFrom(registeredBean.getBeanClass()) && registeredBean.getBeanName().contains("-env-repo-properties") || EnvironmentRepository.class.isAssignableFrom(registeredBean.getBeanClass()) && registeredBean.getBeanName().contains("-env-repo");
    }

    private static final class CompositeEnvironmentBeanFactoryInitializationAotContribution
    implements BeanFactoryInitializationAotContribution {
        private final Map<String, BeanDefinition> propertyBeanDefinitions;
        private final Map<String, BeanDefinition> repoBeanDefinitions;
        private final ConfigurableListableBeanFactory beanFactory;
        private final Set<Class<?>> hintClasses = new HashSet();

        private CompositeEnvironmentBeanFactoryInitializationAotContribution(Map<String, BeanDefinition> propertyBeanDefinitions, Map<String, BeanDefinition> repoBeanDefinitions, ConfigurableListableBeanFactory beanFactory) {
            this.propertyBeanDefinitions = propertyBeanDefinitions;
            this.repoBeanDefinitions = repoBeanDefinitions;
            this.beanFactory = beanFactory;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            GeneratedMethod environmentRepositoryPropertiesGeneratedMethod = beanFactoryInitializationCode.getMethods().add("registerCompositeEnvironmentRepositoryPropertiesBeanDefinitions", this::generateRegisterBeanDefinitionsMethod);
            beanFactoryInitializationCode.addInitializer(environmentRepositoryPropertiesGeneratedMethod.toMethodReference());
            this.generateRuntimeHints(generationContext.getRuntimeHints());
        }

        private void generateRuntimeHints(RuntimeHints runtimeHints) {
            ReflectionHints hints = runtimeHints.reflection();
            for (Class<?> clazz : this.hintClasses) {
                hints.registerType(TypeReference.of(clazz), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS});
                this.introspectPublicMethodsOnAllInterfaces(hints, clazz);
            }
        }

        private void generateRegisterBeanDefinitionsMethod(MethodSpec.Builder method) {
            method.addJavadoc("Register composite environment repository bean definitions for composite config data sources.", new Object[0]);
            method.addModifiers(new Modifier[]{Modifier.PUBLIC});
            method.addParameter(DefaultListableBeanFactory.class, "beanFactory", new Modifier[0]);
            method.addParameter(Environment.class, "environment", new Modifier[0]);
            method.addStatement("$T binder = Binder.get(environment)", new Object[]{Binder.class});
            Pattern findIndexPattern = Pattern.compile("(^.*)(-env-repo-properties)([0-9]+)$");
            this.propertyBeanDefinitions.keySet().forEach(beanName -> {
                Matcher matcher = findIndexPattern.matcher((CharSequence)beanName);
                if (matcher.find()) {
                    String repoBeanName = beanName.replace("repo-properties", "repo");
                    String factoryName = this.repoBeanDefinitions.get(repoBeanName).getFactoryBeanName();
                    Class<?> factoryClass = CompositeUtils.getFactoryClass(this.beanFactory, factoryName);
                    Type[] environmentRepositoryFactoryTypeParams = CompositeUtils.getEnvironmentRepositoryFactoryTypeParams(factoryClass);
                    Class repoClass = (Class)environmentRepositoryFactoryTypeParams[0];
                    Class propertiesClass = (Class)environmentRepositoryFactoryTypeParams[1];
                    this.hintClasses.addAll(Set.of(repoClass, propertiesClass, factoryClass));
                    String indexString = matcher.group(3);
                    int index = Integer.parseInt(indexString);
                    String environmentConfigurationPropertyName = String.format("spring.cloud.config.server.composite[%d]", index);
                    method.addStatement("$T properties$L = binder.bindOrCreate($S, $T.class)", new Object[]{EnvironmentRepositoryProperties.class, index, environmentConfigurationPropertyName, propertiesClass});
                    method.addStatement("properties$L.setOrder($L)", new Object[]{index, index + 1});
                    method.addStatement("$T propertiesDefinition$L = $T.genericBeanDefinition($T.class, () -> properties$L).getBeanDefinition()", new Object[]{AbstractBeanDefinition.class, index, BeanDefinitionBuilder.class, EnvironmentRepositoryProperties.class, index});
                    method.addStatement("beanFactory.registerBeanDefinition($S, propertiesDefinition$L)", new Object[]{beanName, index});
                    method.addStatement("$T repoBeanDefinition$L = $T.genericBeanDefinition($T.class).setFactoryMethodOnBean(\"build\", $S)\n\t.addConstructorArgValue(properties$L).getBeanDefinition()", new Object[]{AbstractBeanDefinition.class, index, BeanDefinitionBuilder.class, EnvironmentRepository.class, factoryName, index});
                    method.addStatement("beanFactory.registerBeanDefinition($S, repoBeanDefinition$L)", new Object[]{repoBeanName, index});
                }
            });
        }

        private void introspectPublicMethodsOnAllInterfaces(ReflectionHints hints, Class<?> type) {
            for (Class<?> currentClass = type; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                for (Class<?> interfaceType : currentClass.getInterfaces()) {
                    if (ClassUtils.isJavaLanguageInterface(interfaceType)) continue;
                    hints.registerType(interfaceType, new MemberCategory[]{MemberCategory.INTROSPECT_PUBLIC_METHODS});
                    this.introspectPublicMethodsOnAllInterfaces(hints, interfaceType);
                }
            }
        }
    }
}

