/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.ntlm.functions;

import com.hierynomus.ntlm.functions.ComputedNtlmV2Response;
import com.hierynomus.ntlm.functions.NtlmFunctions;
import com.hierynomus.ntlm.messages.NtlmChallenge;
import com.hierynomus.ntlm.messages.TargetInfo;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.security.SecurityProvider;
import java.util.Random;
import org.bouncycastle.util.Arrays;

public class NtlmV2Functions {
    private Random random;
    private SecurityProvider securityProvider;

    public NtlmV2Functions(Random random, SecurityProvider securityProvider) {
        this.random = random;
        this.securityProvider = securityProvider;
    }

    public ComputedNtlmV2Response computeResponse(String username, String domain, char[] password, NtlmChallenge serverNtlmChallenge, long time, TargetInfo clientTargetInfo) {
        byte[] clientChallenge = new byte[8];
        this.random.nextBytes(clientChallenge);
        byte[] responseKeyNT = this.NTOWFv2(String.valueOf(password), username, domain);
        byte[] responseKeyLM = this.LMOWFv2(String.valueOf(password), username, domain);
        byte[] lmResponse = this.getLmV2Response(responseKeyLM, serverNtlmChallenge.getServerChallenge(), clientChallenge);
        byte[] ntResponse = this.getNtV2Response(responseKeyNT, serverNtlmChallenge.getServerChallenge(), clientChallenge, time, clientTargetInfo);
        byte[] ntProofStr = Arrays.copyOfRange((byte[])ntResponse, (int)0, (int)16);
        byte[] sessionBaseKey = this.getSessionBaseKey(responseKeyNT, ntProofStr);
        return new ComputedNtlmV2Response(ntResponse, lmResponse, sessionBaseKey);
    }

    public byte[] NTOWFv2(String password, String username, String userDomain) {
        byte[] keyBytes = NtlmFunctions.md4(this.securityProvider, NtlmFunctions.unicode(password));
        byte[] usernameBytes = NtlmFunctions.unicode(username.toUpperCase());
        byte[] userDomainBytes = NtlmFunctions.unicode(userDomain);
        return NtlmFunctions.hmac_md5(this.securityProvider, keyBytes, usernameBytes, userDomainBytes);
    }

    public byte[] LMOWFv2(String password, String username, String userDomain) {
        return this.NTOWFv2(password, username, userDomain);
    }

    public byte[] getLmV2Response(byte[] responseKeyLM, byte[] serverChallenge, byte[] clientChallenge) {
        Buffer.PlainBuffer respBuf = new Buffer.PlainBuffer(Endian.LE);
        byte[] hmac = NtlmFunctions.hmac_md5(this.securityProvider, responseKeyLM, serverChallenge, clientChallenge);
        respBuf.putRawBytes(hmac);
        respBuf.putRawBytes(clientChallenge);
        return respBuf.getCompactData();
    }

    public byte[] getNtV2Response(byte[] responseKeyNT, byte[] serverChallenge, byte[] clientChallenge, long time, TargetInfo targetInfo) {
        byte[] temp = this.ntResponseTemp(clientChallenge, time, targetInfo);
        byte[] ntProofStr = this.ntProofStr(responseKeyNT, serverChallenge, temp);
        byte[] ntChallengeResponse = new byte[ntProofStr.length + temp.length];
        System.arraycopy(ntProofStr, 0, ntChallengeResponse, 0, ntProofStr.length);
        System.arraycopy(temp, 0, ntChallengeResponse, ntProofStr.length, temp.length);
        return ntChallengeResponse;
    }

    public byte[] getSessionBaseKey(byte[] responseKeyNT, byte[] ntProofStr) {
        return NtlmFunctions.hmac_md5(this.securityProvider, responseKeyNT, new byte[][]{ntProofStr});
    }

    byte[] ntResponseTemp(byte[] clientChallenge, long time, TargetInfo targetInfo) {
        Buffer.PlainBuffer ccBuf = new Buffer.PlainBuffer(Endian.LE);
        ccBuf.putByte((byte)1);
        ccBuf.putByte((byte)1);
        ccBuf.putUInt16(0);
        ccBuf.putUInt32(0L);
        ccBuf.putLong(time);
        ccBuf.putRawBytes(clientChallenge);
        ccBuf.putUInt32(0L);
        if (targetInfo != null) {
            targetInfo.writeTo(ccBuf);
        }
        ccBuf.putUInt32(0L);
        return ccBuf.getCompactData();
    }

    byte[] ntProofStr(byte[] responseKeyNT, byte[] serverChallenge, byte[] temp) {
        return NtlmFunctions.hmac_md5(this.securityProvider, responseKeyNT, serverChallenge, temp);
    }

    public byte[] kxKey(byte[] sessionBaseKey, byte[] lmResponse, byte[] serverChallenge) {
        return sessionBaseKey;
    }
}

