/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.impl.fusing.Map;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Framing;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.util.ByteIterator;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class Framing$ {
    public static final Framing$ MODULE$ = new Framing$();
    private static final Function2<ByteIterator, Object, Object> org$apache$pekko$stream$scaladsl$Framing$$bigEndianDecoder = (Function2 & Serializable)(bs, length) -> BoxesRunTime.boxToInteger((int)Framing$.$anonfun$bigEndianDecoder$1(bs, BoxesRunTime.unboxToInt((Object)length)));
    private static final Function2<ByteIterator, Object, Object> org$apache$pekko$stream$scaladsl$Framing$$littleEndianDecoder = (Function2 & Serializable)(bs, length) -> BoxesRunTime.boxToInteger((int)Framing$.$anonfun$littleEndianDecoder$1(bs, BoxesRunTime.unboxToInt((Object)length)));

    public Flow<ByteString, ByteString, NotUsed> delimiter(ByteString delimiter, int maximumFrameLength, boolean allowTruncation) {
        return ((Flow)Flow$.MODULE$.apply().via((Graph)new Framing.DelimiterFramingStage(delimiter, maximumFrameLength, allowTruncation))).named("delimiterFraming");
    }

    public boolean delimiter$default$3() {
        return false;
    }

    public Flow<ByteString, ByteString, NotUsed> lengthField(int fieldLength, int fieldOffset, int maximumFrameLength, ByteOrder byteOrder) {
        Predef$.MODULE$.require(fieldLength >= 1 && fieldLength <= 4, (Function0 & Serializable)() -> "Length field length must be 1, 2, 3 or 4.");
        return ((Flow)Flow$.MODULE$.apply().via((Graph)new Framing.LengthFieldFramingStage(fieldLength, fieldOffset, maximumFrameLength, byteOrder))).named("lengthFieldFraming");
    }

    public Flow<ByteString, ByteString, NotUsed> lengthField(int fieldLength, int fieldOffset, int maximumFrameLength, ByteOrder byteOrder, Function2<byte[], Object, Object> computeFrameSize) {
        Predef$.MODULE$.require(fieldLength >= 1 && fieldLength <= 4, (Function0 & Serializable)() -> "Length field length must be 1, 2, 3 or 4.");
        return ((Flow)Flow$.MODULE$.apply().via((Graph)new Framing.LengthFieldFramingStage(fieldLength, fieldOffset, maximumFrameLength, byteOrder, (Option<Function2<byte[], Object, Object>>)new Some(computeFrameSize)))).named("lengthFieldFraming");
    }

    public int lengthField$default$2() {
        return 0;
    }

    public ByteOrder lengthField$default$4() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public BidiFlow<ByteString, ByteString, ByteString, ByteString, NotUsed> simpleFramingProtocol(int maximumMessageLength) {
        return BidiFlow$.MODULE$.fromFlowsMat(this.simpleFramingProtocolEncoder(maximumMessageLength), this.simpleFramingProtocolDecoder(maximumMessageLength), Keep$.MODULE$.left());
    }

    /*
     * WARNING - void declaration
     */
    public Flow<ByteString, ByteString, NotUsed> simpleFramingProtocolDecoder(int maximumMessageLength) {
        void map_f;
        Flow<ByteString, ByteString, NotUsed> flow = this.lengthField(4, 0, maximumMessageLength + 4, ByteOrder.BIG_ENDIAN);
        Function1 & Serializable intersect = (Function1 & Serializable)x$1 -> x$1.drop(4);
        if (flow == null) {
            throw null;
        }
        Flow<ByteString, ByteString, NotUsed> map_this = flow;
        Map via_flow = new Map(map_f);
        return map_this.via((Graph)via_flow);
    }

    public Flow<ByteString, ByteString, NotUsed> simpleFramingProtocolEncoder(int maximumMessageLength) {
        return Flow$.MODULE$.apply().via((Graph)new Framing.SimpleFramingProtocolEncoder(maximumMessageLength));
    }

    public final Function2<ByteIterator, Object, Object> org$apache$pekko$stream$scaladsl$Framing$$bigEndianDecoder() {
        return org$apache$pekko$stream$scaladsl$Framing$$bigEndianDecoder;
    }

    public final Function2<ByteIterator, Object, Object> org$apache$pekko$stream$scaladsl$Framing$$littleEndianDecoder() {
        return org$apache$pekko$stream$scaladsl$Framing$$littleEndianDecoder;
    }

    public static final /* synthetic */ int $anonfun$bigEndianDecoder$1(ByteIterator bs, int length) {
        int decoded = 0;
        for (int count = length; count > 0; --count) {
            decoded <<= 8;
            decoded |= bs.next() & 0xFF;
        }
        return decoded;
    }

    public static final /* synthetic */ int $anonfun$littleEndianDecoder$1(ByteIterator bs, int length) {
        int highestOctet = length - 1 << 3;
        int Mask = (int)((1L << (length << 3)) - 1L);
        int decoded = 0;
        for (int count = length; count > 0; --count) {
            decoded >>>= 8;
            decoded += (bs.next() & 0xFF) << highestOctet;
        }
        return decoded & Mask;
    }

    private Framing$() {
    }
}

