/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.search;

import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.util.Assert;

public class FilterBasedLdapUserSearch
implements LdapUserSearch {
    private static final Log logger = LogFactory.getLog(FilterBasedLdapUserSearch.class);
    private final ContextSource contextSource;
    private final SearchControls searchControls = new SearchControls();
    private final String searchBase;
    private final String searchFilter;

    public FilterBasedLdapUserSearch(String searchBase, String searchFilter, BaseLdapPathContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        Assert.notNull((Object)searchFilter, (String)"searchFilter must not be null.");
        Assert.notNull((Object)searchBase, (String)"searchBase must not be null (an empty string is acceptable).");
        this.searchFilter = searchFilter;
        this.contextSource = contextSource;
        this.searchBase = searchBase;
        this.setSearchSubtree(true);
        if (searchBase.isEmpty()) {
            logger.info((Object)LogMessage.format((String)"Searches will be performed from the root %s since SearchBase not set", (Object)contextSource.getBaseLdapName()));
        }
    }

    @Override
    public DirContextOperations searchForUser(String username) {
        logger.trace((Object)LogMessage.of(() -> "Searching for user '" + username + "', with " + String.valueOf(this)));
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(this.contextSource);
        template.setSearchControls(this.searchControls);
        try {
            DirContextOperations operations = template.searchForSingleEntry(this.searchBase, this.searchFilter, new String[]{username});
            logger.debug((Object)LogMessage.of(() -> "Found user '" + username + "', with " + String.valueOf(this)));
            return operations;
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            if (ex.getActualSize() == 0) {
                throw new UsernameNotFoundException("User " + username + " not found in directory.");
            }
            throw ex;
        }
    }

    public void setDerefLinkFlag(boolean deref) {
        this.searchControls.setDerefLinkFlag(deref);
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchControls.setSearchScope(searchSubtree ? 2 : 1);
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchControls.setTimeLimit(searchTimeLimit);
    }

    public void setReturningAttributes(String[] attrs) {
        this.searchControls.setReturningAttributes(attrs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append("searchFilter=").append(this.searchFilter).append("; ");
        sb.append("searchBase=").append(this.searchBase).append("; ");
        sb.append("scope=").append(this.searchControls.getSearchScope() != 2 ? "single-level" : "subtree").append("; ");
        sb.append("searchTimeLimit=").append(this.searchControls.getTimeLimit()).append("; ");
        sb.append("derefLinkFlag=").append(this.searchControls.getDerefLinkFlag()).append(" ]");
        return sb.toString();
    }
}

