/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.protobufv3.internal;

import org.apache.pekko.protobufv3.internal.Android;
import org.apache.pekko.protobufv3.internal.CheckReturnValue;
import org.apache.pekko.protobufv3.internal.ListFieldSchema;
import org.apache.pekko.protobufv3.internal.ListFieldSchemaLite;

@CheckReturnValue
final class ListFieldSchemas {
    private static final ListFieldSchema FULL_SCHEMA = ListFieldSchemas.loadSchemaForFullRuntime();
    private static final ListFieldSchema LITE_SCHEMA = new ListFieldSchemaLite();

    static ListFieldSchema full() {
        return FULL_SCHEMA;
    }

    static ListFieldSchema lite() {
        return LITE_SCHEMA;
    }

    private static ListFieldSchema loadSchemaForFullRuntime() {
        if (Android.assumeLiteRuntime) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("org.apache.pekko.protobufv3.internal.ListFieldSchemaFull");
            return (ListFieldSchema)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ListFieldSchemas() {
    }
}

