/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.EnumSet;
import java.util.Map;

public abstract class AbstractTaskConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskState t = (TaskState)source;
        writer.addAttribute("id", t.getId());
        writer.addAttribute("currentStep", Integer.toString(t.getCurrentStepNr()));
        writer.addAttribute("totalSteps", Integer.toString(t.getNrSteps()));
        writer.addAttribute("failures", Integer.toString(t.getFailureCount()));
        if (t.getState() != null) {
            writer.addAttribute("state", this.backwardsCompatibleState(t.getState()).name());
            writer.addAttribute("state2", t.getState().name());
        }
        writer.addAttribute("owner", t.getOwner());
        if (t.getWorkerId() != null) {
            writer.addAttribute("workerId", t.getWorkerId().toString());
        }
        Converters.writeNode("description", t.getDescription(), writer);
        if (t.getStartDate() != null) {
            Converters.writeNode("startDate", new DateTimeAdapter().marshal(t.getStartDate()), writer);
        }
        if (t.getCompletionDate() != null) {
            Converters.writeNode("completionDate", new DateTimeAdapter().marshal(t.getCompletionDate()), writer);
        }
        if (t.getScheduledDate() != null) {
            Converters.writeNode("scheduledDate", new DateTimeAdapter().marshal(t.getScheduledDate()), writer);
        }
        writer.startNode("currentSteps");
        if (t.getCurrentStepNrs() != null) {
            for (Integer current : t.getCurrentStepNrs()) {
                if (current == null) continue;
                Converters.writeNode("current", current.toString(), writer);
            }
        }
        writer.endNode();
        Map metadata = t.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry e : metadata.entrySet()) {
            Converters.writeNode((String)e.getKey(), (String)e.getValue(), writer);
        }
        writer.endNode();
        if (t instanceof TaskWithSteps) {
            this.writeSteps(writer, context, (TaskWithSteps)t);
        }
    }

    protected TaskExecutionState backwardsCompatibleState(TaskExecutionState t) {
        TaskExecutionState retval = t;
        if (t == TaskExecutionState.SCHEDULED) {
            retval = TaskExecutionState.QUEUED;
        } else if (EnumSet.of(TaskExecutionState.STOPPING, TaskExecutionState.FAILING, TaskExecutionState.ABORTING).contains(t)) {
            retval = TaskExecutionState.EXECUTING;
        } else if (EnumSet.of(TaskExecutionState.ABORTED, TaskExecutionState.FAILED).contains(t)) {
            retval = TaskExecutionState.STOPPED;
        }
        return retval;
    }

    private void writeSteps(HierarchicalStreamWriter writer, MarshallingContext context, TaskWithSteps t) {
        writer.startNode("steps");
        Converters.writeSteps(t.getSteps(), writer, context);
        writer.endNode();
    }

    public boolean canConvert(Class type) {
        return TaskState.class.isAssignableFrom(type);
    }
}

