#!/bin/sh
#
# Shell script to install XL Config Server as a daemon
#

DIR=$( cd "$( dirname "$0" )" && pwd )
. "$DIR"/.wrapper-env.sh

# Source .wrapper-env.sh if not already sourced
if [ -z "$xlconfig_home" ]; then
  script_dir="$(dirname "$0")"
  . "$script_dir/.wrapper-env.sh"
fi

read -p "Please provide the user that will run XL Config: " user
export user

conf_file="$xlconfig_home"/conf/xlc-wrapper.conf.common
export template_postfix=""
# install daemon/ service
"$java_exe" "$wrapper_java_options" "$wrapper_logging_file_options" "$wrapper_java_sys_options" -jar "$wrapper_jar" -i "$conf_file"
"$java_exe" "$wrapper_java_options" "$wrapper_logging_file_options" "$wrapper_java_sys_options" -jar "$wrapper_jar" -t "$conf_file"

echo ""
echo "Please make sure the server is configured so that it can start without input from the user"
