/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.mock;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class MockHttpResponse
implements HttpResponse {
    private static final String CHARSET_PREFIX = "charset=";
    private static final String PARAMETER_SEPARATOR = ";";
    protected int status;
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected OutputStream os = this.baos;
    protected CaseInsensitiveMap<Object> outputHeaders = new CaseInsensitiveMap();
    protected List<NewCookie> newCookies = new ArrayList<NewCookie>();
    protected String errorMessage;
    protected boolean sentError = false;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public byte[] getOutput() {
        return this.baos.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        String charset = this.getCharset();
        return charset == null ? this.baos.toString() : this.baos.toString(charset);
    }

    private String getCharset() {
        int charsetEndIndex;
        int charsetStartIndex;
        String characterEncoding = null;
        MultivaluedMap<String, Object> headers = this.getOutputHeaders();
        Object obj = headers.getFirst((Object)"Content-Type");
        String value = null;
        value = obj instanceof MediaType ? ((MediaType)obj).toString() : (String)obj;
        if (value != null && !value.isEmpty() && (charsetStartIndex = value.toLowerCase().indexOf(CHARSET_PREFIX)) != -1 && (charsetEndIndex = (characterEncoding = value.substring(charsetStartIndex + CHARSET_PREFIX.length())).indexOf(PARAMETER_SEPARATOR)) != -1) {
            characterEncoding = characterEncoding.substring(0, charsetEndIndex).trim();
        }
        return characterEncoding;
    }

    public void addNewCookie(NewCookie cookie) {
        this.newCookies.add(cookie);
    }

    public void sendError(int status) throws IOException {
        this.sentError = true;
        this.status = status;
    }

    public void sendError(int status, String message) throws IOException {
        this.sentError = true;
        this.status = status;
        this.errorMessage = message;
    }

    public List<NewCookie> getNewCookies() {
        return this.newCookies;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isErrorSent() {
        return this.sentError;
    }

    public boolean isCommitted() {
        return this.baos.size() > 0;
    }

    public void reset() {
        this.baos = new ByteArrayOutputStream();
        this.os = this.baos;
        this.outputHeaders = new CaseInsensitiveMap();
        this.newCookies = new ArrayList<NewCookie>();
        this.sentError = false;
        this.status = 0;
        this.errorMessage = null;
    }

    public void flushBuffer() throws IOException {
    }
}

