/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.util.Encode;

public class FormParamInjector
extends StringParameterInjector
implements ValueInjector {
    private boolean encode;

    public FormParamInjector(Class type, Type genericType, AccessibleObject target, String header, String defaultValue, boolean encode, Annotation[] annotations, ResteasyProviderFactory factory) {
        super(type, genericType, header, FormParam.class, defaultValue, target, annotations, factory, Map.of(FormParam.class, List.of(InputStream.class, EntityPart.class)));
        this.encode = encode;
    }

    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        if (EntityPart.class.isAssignableFrom(this.type)) {
            return request.getFormEntityPart(this.paramName).orElse(null);
        }
        if (List.class.isAssignableFrom(this.type) && Types.isGenericTypeInstanceOf(EntityPart.class, (Type)this.baseGenericType)) {
            return request.getFormEntityParts();
        }
        if (InputStream.class.isAssignableFrom(this.type)) {
            Optional part = request.getFormEntityPart(this.paramName);
            return part.map(EntityPart::getContent).orElse(null);
        }
        if (String.class.isAssignableFrom(this.type) && MediaType.MULTIPART_FORM_DATA_TYPE.isCompatible(request.getHttpHeaders().getMediaType())) {
            Optional part = request.getFormEntityPart(this.paramName);
            return part.map(p -> {
                try {
                    return (String)p.getContent(String.class);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(Messages.MESSAGES.unableToExtractParameter(this.paramName, null), e);
                }
            }).orElse(null);
        }
        ArrayList<String> list = (ArrayList<String>)request.getDecodedFormParameters().get((Object)this.paramName);
        if (list != null && this.encode) {
            ArrayList<String> encodedList = new ArrayList<String>();
            for (String s : list) {
                encodedList.add(Encode.encodeString(s));
            }
            list = encodedList;
        }
        return this.extractValues((List<String>)list);
    }

    public Object inject(boolean unwrapAsync) {
        throw new RuntimeException(Messages.MESSAGES.illegalToInjectFormParam());
    }
}

