/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.engine.spi.event.LoginEvent;
import com.xebialabs.deployit.engine.spi.event.LogoutEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.security.Permissions;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class RememberMe {
    private static final Cache<String, Authentication> AUTH_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private static final Logger logger = LoggerFactory.getLogger(RememberMe.class);

    public static void remember(Authentication auth) {
        String key = RememberMe.createKey(auth);
        logger.debug("Remembering authentication token for [{}]", (Object)auth.getName());
        if (AUTH_CACHE.getIfPresent((Object)key) == null) {
            EventBusHolder.publish((Object)new LoginEvent(auth.getName()));
        }
        AUTH_CACHE.put((Object)key, (Object)auth);
    }

    public static void forget(Authentication auth) {
        String key = RememberMe.createKey(auth);
        if (AUTH_CACHE.getIfPresent((Object)key) != null) {
            AUTH_CACHE.invalidate((Object)key);
            EventBusHolder.publish((Object)new LogoutEvent(auth.getName()));
        } else {
            logger.info("Couldn't forget authentication for [{}] because it was not remembered.", (Object)auth.getName());
        }
    }

    public static Authentication getRemembered(String username, String password) {
        String key = RememberMe.encodeUserPassword(username, password);
        Authentication ifPresent = (Authentication)AUTH_CACHE.getIfPresent((Object)key);
        if (ifPresent == null) {
            logger.debug("Token for [{}] not yet remembered.", (Object)username);
        }
        return ifPresent;
    }

    public static void forgetMe() {
        RememberMe.forget(Permissions.getAuthentication());
    }

    private static String createKey(Authentication auth) {
        if (auth instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
            String user = token.getName();
            String password = token.getCredentials().toString();
            return RememberMe.encodeUserPassword(user, password);
        }
        throw new IllegalArgumentException("The authentication should always be a UsernamePasswordAuthenticationToken");
    }

    private static String encodeUserPassword(String user, String password) {
        return new String(new Base64Coder().encode((user + ":" + password).getBytes()), Charset.defaultCharset());
    }
}

