/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import com.xebialabs.deployit.upgrade.UpgradeStrategy;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlplatform.upgrade.UpgraderHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Upgrader
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(Upgrader.class);
    private final Set<String> components = new LinkedHashSet<String>();
    private final String COMPONENT_DEPLOYIT = "deployit";
    private final Map<String, List<Upgrade>> upgrades = new HashMap<String, List<Upgrade>>();
    private final boolean forceUpgrades;
    private ApplicationContext applicationContext;
    private final UpgradeStrategy upgradeStrategy;
    private boolean questionAsked = false;
    private final RepositoryVersionService repositoryVersionService;

    public Upgrader(UpgradeStrategy upgradeStrategy, boolean forceUpgrades, RepositoryVersionService repositoryVersionService) {
        this.upgradeStrategy = upgradeStrategy;
        this.forceUpgrades = forceUpgrades;
        this.repositoryVersionService = repositoryVersionService;
    }

    public void addComponent(String component) {
        this.components.add(component);
    }

    public void addUpgrade(Upgrade upgrade) {
        String component = upgrade.upgradeVersion().getComponent();
        this.addComponent(component);
        this.upgrades.computeIfAbsent(component, c -> new ArrayList()).add(upgrade);
    }

    public void applyUpgrades() {
        this.applyUpgrades(false);
    }

    public void applyUpgrades(boolean verifyOnly) {
        this.components.forEach(component -> this.upgradeComponent((String)component, verifyOnly));
    }

    public void autoUpgrade() {
        this.autoUpgrade(false);
    }

    public void autoUpgrade(boolean verifyOnly) {
        PluginVersions.getRegisteredPlugins().stream().sorted((left, right) -> "deployit".equals(left) ? -1 : 0).forEach(this.components::add);
        this.findUpgrades().forEach((c, l) -> this.upgrades.computeIfAbsent((String)c, i -> new ArrayList()).addAll(l));
        this.applyUpgrades(verifyOnly);
    }

    public Version getComponentVersion(String component) {
        return this.repositoryVersionService.readVersionOfComponent(component);
    }

    void upgradeComponent(String component) {
        this.upgradeComponent(component, false);
    }

    void upgradeComponent(String component, boolean verifyOnly) {
        Version componentVersion;
        logger.debug("Checking component [{}] for upgrades", (Object)component);
        try {
            componentVersion = this.getComponentVersion(component);
        }
        catch (RuntimeException e) {
            logger.warn(String.format("Component [%s] has an invalid version -- skipping upgrade", component), (Throwable)e);
            return;
        }
        if (componentVersion == null) {
            logger.debug("Skipping upgrade of component {} as it is not registered", (Object)component);
            return;
        }
        logger.debug("Component [{}] has version [{}] in the repository", (Object)component, (Object)componentVersion);
        List componentUpgrades = Optional.ofNullable(this.upgrades.get(component)).orElse(new ArrayList());
        List<Upgrade> applicableUpgrades = UpgraderHelper.filterApplicable(componentUpgrades, componentVersion);
        if (componentVersion.isVersion0()) {
            if (verifyOnly) {
                throw new UpgradeRejectedException("Verification failed, found new component.");
            }
            Version versionOfComponent = UpgraderHelper.findRecentVersion(applicableUpgrades, component);
            if (versionOfComponent == null && PluginVersions.getVersionFor((String)component) != null) {
                versionOfComponent = Version.valueOf((String)component, (String)PluginVersions.getVersionFor((String)component));
            }
            this.repositoryVersionService.storeVersionOfComponent(versionOfComponent);
            logger.debug("Setting version [{}] for component [{}]", (Object)versionOfComponent, (Object)component);
            return;
        }
        if (!applicableUpgrades.isEmpty()) {
            logger.info("Checked component [{}] which is at version [{}] -> Found upgrades to run: {}", new Object[]{component, componentVersion, applicableUpgrades});
            if (verifyOnly) {
                throw new UpgradeRejectedException("Verification failed, found new upgrades to apply.");
            }
            if (applicableUpgrades.stream().anyMatch(Upgrade::isAskForUpgrade)) {
                this.askForUpgrade();
            }
            this.applyUpgrades(applicableUpgrades);
        }
    }

    public void askForUpgrade() {
        if (!this.questionAsked && !this.forceUpgrades) {
            logger.warn("Ensure that you're running in 'interactive' mode and look at your console to continue the upgrade process.");
            String NL = System.lineSeparator();
            logger.info("Upgraders need to be run, asking user to confirm.");
            String msg = NL + "*** WARNING ***" + NL + "We detected that we need to upgrade your repository" + NL + "Before continuing we suggest you backup your repository in case the upgrade fails." + NL + "Please ensure you have 'INFO' level logging configured." + NL + "Please enter 'yes' if you want to continue [no]: ";
            System.out.print(msg);
            String response = this.read();
            if (!"yes".equalsIgnoreCase(response)) {
                logger.error("Did not receive an affirmative response on running upgrades, shutting down.");
                EventBusHolder.publish((Object)new ShutdownEvent());
                throw new UpgradeRejectedException("Did not receive an affirmative response on running upgrades, shutting down.");
            }
            logger.info("User response was: {}", (Object)response);
            this.questionAsked = true;
        }
    }

    private void applyUpgrades(List<Upgrade> applicableUpgrades) {
        Set versions = applicableUpgrades.stream().map(Upgrade::upgradeVersion).collect(Collectors.toCollection(TreeSet::new));
        HashMap versionToUpgradeMap = new HashMap();
        applicableUpgrades.forEach(u -> versionToUpgradeMap.computeIfAbsent(u.upgradeVersion(), v -> new ArrayList()).add(u));
        for (Version version : versions) {
            this.updateVersion(version, (List)versionToUpgradeMap.get(version));
        }
    }

    protected void updateVersion(Version version, List<Upgrade> upgrades) {
        logger.info("Upgrading to version [{}]", (Object)version);
        this.upgradeStrategy.doUpgrades(upgrades);
        this.repositoryVersionService.storeVersionOfComponent(version);
    }

    public Map<String, List<Upgrade>> findUpgrades() {
        Set upgradeClasses = this.upgradeStrategy.findApplicableUpgradeTypes();
        Set<Upgrade> allUpgrades = UpgraderHelper.instantiateClasses(upgradeClasses, this.applicationContext);
        logger.debug("Found the following upgrades: [{}]", allUpgrades);
        HashMap<String, List<Upgrade>> byComponent = new HashMap<String, List<Upgrade>>();
        allUpgrades.forEach(u -> byComponent.computeIfAbsent(u.upgradeVersion().getComponent(), c -> new ArrayList()).add(u));
        return byComponent;
    }

    protected String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                return line.trim();
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

