/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.web.jetty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.metrics.web.jetty.JettyConnectionMetricsBinder;
import org.springframework.boot.actuate.metrics.web.jetty.JettyServerThreadPoolMetricsBinder;
import org.springframework.boot.actuate.metrics.web.jetty.JettySslHandshakeMetricsBinder;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnWebApplication
@ConditionalOnClass(value={JettyServerThreadPoolMetrics.class, Server.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class JettyMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JettyServerThreadPoolMetrics.class, JettyServerThreadPoolMetricsBinder.class})
    public JettyServerThreadPoolMetricsBinder jettyServerThreadPoolMetricsBinder(MeterRegistry meterRegistry) {
        return new JettyServerThreadPoolMetricsBinder(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JettyConnectionMetrics.class, JettyConnectionMetricsBinder.class})
    public JettyConnectionMetricsBinder jettyConnectionMetricsBinder(MeterRegistry meterRegistry) {
        return new JettyConnectionMetricsBinder(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JettySslHandshakeMetrics.class, JettySslHandshakeMetricsBinder.class})
    @ConditionalOnProperty(name={"server.ssl.enabled"}, havingValue="true")
    public JettySslHandshakeMetricsBinder jettySslHandshakeMetricsBinder(MeterRegistry meterRegistry) {
        return new JettySslHandshakeMetricsBinder(meterRegistry);
    }
}

