/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.grpc.ChannelPool;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GrpcChannelUUIDInterceptor;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.internal.EnvironmentProvider;
import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.api.gax.util.TimeConversionUtils;
import com.google.auth.ApiKeyCredentials;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import io.grpc.CallCredentials;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.alts.GoogleDefaultChannelCredentials;
import io.grpc.auth.MoreCallCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import org.threeten.bp.Duration;

public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    private static String systemProductName;
    @VisibleForTesting
    static final Logger LOG;
    static final String DIRECT_PATH_ENV_DISABLE_DIRECT_PATH = "GOOGLE_CLOUD_DISABLE_DIRECT_PATH";
    @VisibleForTesting
    static final String DIRECT_PATH_ENV_ENABLE_XDS = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH_XDS";
    static final long DIRECT_PATH_KEEP_ALIVE_TIME_SECONDS = 3600L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIMEOUT_SECONDS = 20L;
    static final String GCE_PRODUCTION_NAME_PRIOR_2016 = "Google";
    static final String GCE_PRODUCTION_NAME_AFTER_2016 = "Google Compute Engine";
    private final int processorCount;
    private final Executor executor;
    private final HeaderProvider headerProvider;
    private final String endpoint;
    private final EnvironmentProvider envProvider;
    @Nullable
    private final GrpcInterceptorProvider interceptorProvider;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Integer maxInboundMetadataSize;
    @Nullable
    private final java.time.Duration keepAliveTime;
    @Nullable
    private final java.time.Duration keepAliveTimeout;
    @Nullable
    private final Boolean keepAliveWithoutCalls;
    private final ChannelPoolSettings channelPoolSettings;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final ChannelPrimer channelPrimer;
    @Nullable
    private final Boolean attemptDirectPath;
    @Nullable
    private final Boolean attemptDirectPathXds;
    @Nullable
    private final Boolean allowNonDefaultServiceAccount;
    @VisibleForTesting
    final ImmutableMap<String, ?> directPathServiceConfig;
    @Nullable
    private final MtlsProvider mtlsProvider;
    @VisibleForTesting
    final Map<String, String> headersWithDuplicatesRemoved = new HashMap<String, String>();
    @Nullable
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    private InstantiatingGrpcChannelProvider(Builder builder) {
        this.processorCount = builder.processorCount;
        this.executor = builder.executor;
        this.headerProvider = builder.headerProvider;
        this.endpoint = builder.endpoint;
        this.mtlsProvider = builder.mtlsProvider;
        this.envProvider = builder.envProvider;
        this.interceptorProvider = builder.interceptorProvider;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.channelPoolSettings = builder.channelPoolSettings;
        this.channelConfigurator = builder.channelConfigurator;
        this.credentials = builder.credentials;
        this.channelPrimer = builder.channelPrimer;
        this.attemptDirectPath = builder.attemptDirectPath;
        this.attemptDirectPathXds = builder.attemptDirectPathXds;
        this.allowNonDefaultServiceAccount = builder.allowNonDefaultServiceAccount;
        this.directPathServiceConfig = builder.directPathServiceConfig == null ? InstantiatingGrpcChannelProvider.getDefaultDirectPathServiceConfig() : builder.directPathServiceConfig;
    }

    @VisibleForTesting
    InstantiatingGrpcChannelProvider(Builder builder, String productName) {
        this(builder);
        systemProductName = productName;
    }

    @Deprecated
    public boolean needsExecutor() {
        return this.executor == null;
    }

    @Deprecated
    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.withExecutor((Executor)executor);
    }

    public TransportChannelProvider withExecutor(Executor executor) {
        return this.toBuilder().setExecutor(executor).build();
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @Deprecated
    public boolean acceptsPoolSize() {
        return true;
    }

    @Deprecated
    public TransportChannelProvider withPoolSize(int size) {
        return this.toBuilder().setPoolSize(size).build();
    }

    public boolean needsCredentials() {
        return this.credentials == null;
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        return this.toBuilder().setCredentials(credentials).build();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        if (this.needsEndpoint()) {
            throw new IllegalStateException("getTransportChannel() called when needsEndpoint() is true");
        }
        this.logDirectPathMisconfig();
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        return GrpcTransportChannel.newBuilder().setManagedChannel(ChannelPool.create(this.channelPoolSettings, this::createSingleChannel)).setDirectPath(this.canUseDirectPath()).build();
    }

    private boolean isDirectPathEnabled() {
        String disableDirectPathEnv = this.envProvider.getenv(DIRECT_PATH_ENV_DISABLE_DIRECT_PATH);
        boolean isDirectPathDisabled = Boolean.parseBoolean(disableDirectPathEnv);
        if (isDirectPathDisabled) {
            return false;
        }
        if (this.attemptDirectPath != null) {
            return this.attemptDirectPath;
        }
        return false;
    }

    private boolean isDirectPathXdsEnabledViaBuilderOption() {
        return Boolean.TRUE.equals(this.attemptDirectPathXds);
    }

    private boolean isDirectPathXdsEnabledViaEnv() {
        String directPathXdsEnv = this.envProvider.getenv(DIRECT_PATH_ENV_ENABLE_XDS);
        return Boolean.parseBoolean(directPathXdsEnv);
    }

    @InternalApi
    public boolean isDirectPathXdsEnabled() {
        return this.isDirectPathXdsEnabledViaEnv() || this.isDirectPathXdsEnabledViaBuilderOption();
    }

    private void logDirectPathMisconfig() {
        if (this.isDirectPathXdsEnabled()) {
            if (!this.isDirectPathEnabled()) {
                if (this.isDirectPathXdsEnabledViaEnv()) {
                    LOG.log(Level.WARNING, "Env var GOOGLE_CLOUD_ENABLE_DIRECT_PATH_XDS was found and set to TRUE, but DirectPath was not enabled for this client. If this is intended for this client, please note that this is a misconfiguration and set the attemptDirectPath option as well.");
                } else if (this.isDirectPathXdsEnabledViaBuilderOption()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. The DirectPath XDS option was set, but the attemptDirectPath option was not. Please set both the attemptDirectPath and attemptDirectPathXds options.");
                }
            } else {
                if (!this.isCredentialDirectPathCompatible()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. Please make sure the credential is an instance of " + ComputeEngineCredentials.class.getName() + " .");
                }
                if (!InstantiatingGrpcChannelProvider.isOnComputeEngine()) {
                    LOG.log(Level.WARNING, "DirectPath is misconfigured. DirectPath is only available in a GCE environment.");
                }
            }
        }
    }

    @VisibleForTesting
    boolean isCredentialDirectPathCompatible() {
        if (this.needsCredentials()) {
            return false;
        }
        if (this.allowNonDefaultServiceAccount != null && this.allowNonDefaultServiceAccount.booleanValue()) {
            return true;
        }
        return this.credentials instanceof ComputeEngineCredentials;
    }

    @VisibleForTesting
    static boolean isOnComputeEngine() {
        String osName = System.getProperty("os.name");
        if ("Linux".equals(osName)) {
            String systemProductName = InstantiatingGrpcChannelProvider.getSystemProductName();
            return systemProductName.contains(GCE_PRODUCTION_NAME_PRIOR_2016) || systemProductName.contains(GCE_PRODUCTION_NAME_AFTER_2016);
        }
        return false;
    }

    private static String getSystemProductName() {
        if (systemProductName != null) {
            return systemProductName;
        }
        try {
            return Files.asCharSource((File)new File("/sys/class/dmi/id/product_name"), (Charset)StandardCharsets.UTF_8).readFirstLine();
        }
        catch (IOException e) {
            return "";
        }
    }

    @VisibleForTesting
    boolean canUseDirectPathWithUniverseDomain() {
        return this.endpoint.contains("googleapis.com");
    }

    @VisibleForTesting
    ChannelCredentials createMtlsChannelCredentials() throws IOException, GeneralSecurityException {
        KeyStore mtlsKeyStore;
        if (this.mtlsProvider.useMtlsClientCertificate() && (mtlsKeyStore = this.mtlsProvider.getKeyStore()) != null) {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(mtlsKeyStore, new char[0]);
            return TlsChannelCredentials.newBuilder().keyManager(factory.getKeyManagers()).build();
        }
        return null;
    }

    private ManagedChannel createSingleChannel() throws IOException {
        ManagedChannelBuilder builder;
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headersWithDuplicatesRemoved);
        GrpcMetadataHandlerInterceptor metadataHandlerInterceptor = new GrpcMetadataHandlerInterceptor();
        int colon = this.endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        boolean useDirectPathXds = false;
        if (this.canUseDirectPath()) {
            CallCredentials callCreds = MoreCallCredentials.from((Credentials)this.credentials);
            ChannelCredentials channelCreds = GoogleDefaultChannelCredentials.newBuilder().callCredentials(callCreds).build();
            useDirectPathXds = this.isDirectPathXdsEnabled();
            if (useDirectPathXds) {
                builder = Grpc.newChannelBuilder((String)("google-c2p:///" + serviceAddress), (ChannelCredentials)channelCreds);
            } else {
                builder = Grpc.newChannelBuilderForAddress((String)serviceAddress, (int)port, (ChannelCredentials)channelCreds);
                builder.defaultServiceConfig(this.directPathServiceConfig);
            }
            builder.keepAliveTime(3600L, TimeUnit.SECONDS);
            builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
        } else {
            ChannelCredentials channelCredentials;
            try {
                channelCredentials = this.createMtlsChannelCredentials();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            builder = channelCredentials != null ? Grpc.newChannelBuilder((String)this.endpoint, (ChannelCredentials)channelCredentials) : ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
        }
        if (!useDirectPathXds) {
            builder.disableServiceConfigLookUp();
        }
        builder = builder.intercept(new ClientInterceptor[]{new GrpcChannelUUIDInterceptor()}).intercept(new ClientInterceptor[]{headerInterceptor}).intercept(new ClientInterceptor[]{metadataHandlerInterceptor}).userAgent(headerInterceptor.getUserAgentHeader()).executor(this.executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize.intValue());
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = (ManagedChannelBuilder)this.channelConfigurator.apply((Object)builder);
        }
        ManagedChannel managedChannel = builder.build();
        if (this.channelPrimer != null) {
            this.channelPrimer.primeChannel(managedChannel);
        }
        return managedChannel;
    }

    private void removeApiKeyCredentialDuplicateHeaders() {
        if (this.headerProvider != null) {
            this.headersWithDuplicatesRemoved.putAll(this.headerProvider.getHeaders());
        }
        if (this.credentials != null && this.credentials instanceof ApiKeyCredentials) {
            try {
                Map credentialRequestMetatData = this.credentials.getRequestMetadata();
                if (credentialRequestMetatData != null) {
                    this.headersWithDuplicatesRemoved.keySet().removeAll(credentialRequestMetatData.keySet());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @InternalApi
    public boolean canUseDirectPath() {
        return this.isDirectPathEnabled() && this.isCredentialDirectPathCompatible() && InstantiatingGrpcChannelProvider.isOnComputeEngine() && this.canUseDirectPathWithUniverseDomain();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @ObsoleteApi(value="Use getKeepAliveTimeDuration() instead")
    public Duration getKeepAliveTime() {
        return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getKeepAliveTimeDuration());
    }

    public java.time.Duration getKeepAliveTimeDuration() {
        return this.keepAliveTime;
    }

    @ObsoleteApi(value="Use getKeepAliveTimeoutDuration() instead")
    public Duration getKeepAliveTimeout() {
        return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getKeepAliveTimeoutDuration());
    }

    public java.time.Duration getKeepAliveTimeoutDuration() {
        return this.keepAliveTimeout;
    }

    public Boolean getKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
    public Integer getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    @BetaApi(value="Channel pool sizing api is not yet stable")
    public ChannelPoolSettings getChannelPoolSettings() {
        return this.channelPoolSettings;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static ImmutableMap<String, ?> getDefaultDirectPathServiceConfig() {
        ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
        return ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
    }

    private static void validateEndpoint(String endpoint) {
        int colon = endpoint.lastIndexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
        }
        Integer.parseInt(endpoint.substring(colon + 1));
    }

    static {
        LOG = Logger.getLogger(InstantiatingGrpcChannelProvider.class.getName());
    }

    public static final class Builder {
        @Deprecated
        private int processorCount;
        private Executor executor;
        private HeaderProvider headerProvider;
        private String endpoint;
        private EnvironmentProvider envProvider;
        private MtlsProvider mtlsProvider = new MtlsProvider();
        @Nullable
        private GrpcInterceptorProvider interceptorProvider;
        @Nullable
        private Integer maxInboundMessageSize;
        @Nullable
        private Integer maxInboundMetadataSize;
        @Nullable
        private java.time.Duration keepAliveTime;
        @Nullable
        private java.time.Duration keepAliveTimeout;
        @Nullable
        private Boolean keepAliveWithoutCalls;
        @Nullable
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        @Nullable
        private Credentials credentials;
        @Nullable
        private ChannelPrimer channelPrimer;
        private ChannelPoolSettings channelPoolSettings;
        @Nullable
        private Boolean attemptDirectPath;
        @Nullable
        private Boolean attemptDirectPathXds;
        @Nullable
        private Boolean allowNonDefaultServiceAccount;
        @Nullable
        private ImmutableMap<String, ?> directPathServiceConfig;

        private Builder() {
            this.processorCount = Runtime.getRuntime().availableProcessors();
            this.envProvider = System::getenv;
            this.channelPoolSettings = ChannelPoolSettings.staticallySized(1);
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.processorCount = provider.processorCount;
            this.executor = provider.executor;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.envProvider = provider.envProvider;
            this.interceptorProvider = provider.interceptorProvider;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
            this.maxInboundMetadataSize = provider.maxInboundMetadataSize;
            this.keepAliveTime = provider.keepAliveTime;
            this.keepAliveTimeout = provider.keepAliveTimeout;
            this.keepAliveWithoutCalls = provider.keepAliveWithoutCalls;
            this.channelConfigurator = provider.channelConfigurator;
            this.credentials = provider.credentials;
            this.channelPrimer = provider.channelPrimer;
            this.channelPoolSettings = provider.channelPoolSettings;
            this.attemptDirectPath = provider.attemptDirectPath;
            this.attemptDirectPathXds = provider.attemptDirectPathXds;
            this.allowNonDefaultServiceAccount = provider.allowNonDefaultServiceAccount;
            this.directPathServiceConfig = provider.directPathServiceConfig;
            this.mtlsProvider = provider.mtlsProvider;
        }

        @Deprecated
        Builder setProcessorCount(int processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Deprecated
        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            return this.setExecutor(executorProvider.getExecutor());
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        @VisibleForTesting
        Builder setMtlsProvider(MtlsProvider mtlsProvider) {
            this.mtlsProvider = mtlsProvider;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Builder setMaxInboundMetadataSize(Integer max) {
            this.maxInboundMetadataSize = max;
            return this;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Integer getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        @ObsoleteApi(value="Use setKeepAliveTimeDuration(java.time.Duration) instead")
        public Builder setKeepAliveTime(Duration duration) {
            return this.setKeepAliveTimeDuration(TimeConversionUtils.toJavaTimeDuration((Duration)duration));
        }

        public Builder setKeepAliveTimeDuration(java.time.Duration duration) {
            this.keepAliveTime = duration;
            return this;
        }

        @ObsoleteApi(value="Use getKeepAliveTimeDuration() instead")
        public Duration getKeepAliveTime() {
            return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getKeepAliveTimeDuration());
        }

        public java.time.Duration getKeepAliveTimeDuration() {
            return this.keepAliveTime;
        }

        @ObsoleteApi(value="Use setKeepAliveTimeoutDuration(java.time.Duration) instead")
        public Builder setKeepAliveTimeout(Duration duration) {
            return this.setKeepAliveTimeoutDuration(TimeConversionUtils.toJavaTimeDuration((Duration)duration));
        }

        public Builder setKeepAliveTimeoutDuration(java.time.Duration duration) {
            this.keepAliveTimeout = duration;
            return this;
        }

        @ObsoleteApi(value="Use getKeepAliveTimeoutDuration() instead")
        public Duration getKeepAliveTimeout() {
            return TimeConversionUtils.toThreetenDuration((java.time.Duration)this.getKeepAliveTimeoutDuration());
        }

        public java.time.Duration getKeepAliveTimeoutDuration() {
            return this.keepAliveTimeout;
        }

        public Builder setKeepAliveWithoutCalls(Boolean keepalive) {
            this.keepAliveWithoutCalls = keepalive;
            return this;
        }

        public Boolean getKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        @Deprecated
        public int getPoolSize() {
            return this.channelPoolSettings.getInitialChannelCount();
        }

        @Deprecated
        public Builder setPoolSize(int poolSize) {
            this.channelPoolSettings = ChannelPoolSettings.staticallySized(poolSize);
            return this;
        }

        @Deprecated
        public Builder setChannelsPerCpu(double multiplier) {
            return this.setChannelsPerCpu(multiplier, 100);
        }

        @Deprecated
        public Builder setChannelsPerCpu(double multiplier, int maxChannels) {
            Preconditions.checkArgument((multiplier > 0.0 ? 1 : 0) != 0, (Object)"multiplier must be positive");
            Preconditions.checkArgument((maxChannels > 0 ? 1 : 0) != 0, (Object)"maxChannels must be positive");
            int channelCount = (int)Math.ceil((double)this.processorCount * multiplier);
            if (channelCount > maxChannels) {
                channelCount = maxChannels;
            }
            return this.setChannelPoolSettings(ChannelPoolSettings.staticallySized(channelCount));
        }

        @BetaApi(value="Channel pool sizing api is not yet stable")
        public Builder setChannelPoolSettings(ChannelPoolSettings settings) {
            this.channelPoolSettings = settings;
            return this;
        }

        public Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setChannelPrimer(ChannelPrimer channelPrimer) {
            this.channelPrimer = channelPrimer;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAttemptDirectPath(boolean attemptDirectPath) {
            this.attemptDirectPath = attemptDirectPath;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAllowNonDefaultServiceAccount(boolean allowNonDefaultServiceAccount) {
            this.allowNonDefaultServiceAccount = allowNonDefaultServiceAccount;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setAttemptDirectPathXds() {
            this.attemptDirectPathXds = true;
            return this;
        }

        @VisibleForTesting
        Builder setEnvProvider(EnvironmentProvider envProvider) {
            this.envProvider = envProvider;
            return this;
        }

        @InternalApi(value="For internal use by google-cloud-java clients only")
        public Builder setDirectPathServiceConfig(Map<String, ?> serviceConfig) {
            Preconditions.checkNotNull(serviceConfig, (Object)"serviceConfig");
            this.directPathServiceConfig = ImmutableMap.copyOf(serviceConfig);
            return this;
        }

        public InstantiatingGrpcChannelProvider build() {
            InstantiatingGrpcChannelProvider instantiatingGrpcChannelProvider = new InstantiatingGrpcChannelProvider(this);
            instantiatingGrpcChannelProvider.removeApiKeyCredentialDuplicateHeaders();
            return instantiatingGrpcChannelProvider;
        }

        @BetaApi(value="Surface for advanced channel configuration is not yet stable")
        public Builder setChannelConfigurator(@Nullable ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        @Nullable
        public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
            return this.channelConfigurator;
        }
    }
}

