/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.Map;
import org.springframework.cloud.config.server.encryption.PassthruSecretLocator;
import org.springframework.cloud.config.server.encryption.SecretLocator;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.security.crypto.encrypt.KeyStoreKeyFactory;
import org.springframework.security.crypto.encrypt.RsaAlgorithm;
import org.springframework.security.crypto.encrypt.RsaSecretEncryptor;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class KeyStoreTextEncryptorLocator
implements TextEncryptorLocator {
    private static final String KEY = "key";
    private static final String SECRET = "secret";
    private KeyStoreKeyFactory keys;
    private String defaultSecret;
    private String defaultAlias;
    private RsaSecretEncryptor defaultEncryptor;
    private SecretLocator secretLocator = new PassthruSecretLocator();
    private RsaAlgorithm rsaAlgorithm = RsaAlgorithm.DEFAULT;
    private boolean strong = false;
    private String salt = "deadbeef";

    public KeyStoreTextEncryptorLocator(KeyStoreKeyFactory keys, String defaultSecret, String defaultAlias) {
        this.keys = keys;
        this.defaultAlias = defaultAlias;
        this.defaultSecret = defaultSecret;
    }

    public void setSecretLocator(SecretLocator secretLocator) {
        this.secretLocator = secretLocator;
    }

    public void setRsaAlgorithm(RsaAlgorithm rsaAlgorithm) {
        this.rsaAlgorithm = rsaAlgorithm;
    }

    public void setStrong(boolean strong) {
        this.strong = strong;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Override
    public TextEncryptor locate(Map<String, String> keys) {
        String secret;
        String alias = keys.containsKey(KEY) ? keys.get(KEY) : this.defaultAlias;
        String string = secret = keys.containsKey(SECRET) ? keys.get(SECRET) : this.defaultSecret;
        if (alias.equals(this.defaultAlias) && secret.equals(this.defaultSecret)) {
            if (this.defaultEncryptor == null) {
                this.defaultEncryptor = this.rsaSecretEncryptor(alias, secret);
            }
            return this.defaultEncryptor;
        }
        return this.rsaSecretEncryptor(alias, secret);
    }

    private RsaSecretEncryptor rsaSecretEncryptor(String alias, String secret) {
        return new RsaSecretEncryptor(this.keys.getKeyPair(alias, this.secretLocator.locate(secret)), this.rsaAlgorithm, this.salt, this.strong);
    }
}

