/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.formmgr;

import com.jeta.forms.beanmgr.BeanManager;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLUtils;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.FormPackage;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class FormManagerUtils {
    private static final int DEFAULT_BUFFER_SIZE = 20480;

    public static FormMemento loadForm(InputStream inputStream) throws ClassNotFoundException, IOException, JMLException {
        if (inputStream instanceof ObjectInputStream) {
            FormMemento formMemento = null;
            Object object = ((ObjectInputStream)inputStream).readObject();
            formMemento = object instanceof FormPackage ? ((FormPackage)object).getMemento() : (FormMemento)object;
            return formMemento;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[20480];
        int n = inputStream.read(byArray);
        if (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray2);
        }
        while (n > 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
            n = inputStream.read(byArray2);
        }
        boolean bl = true;
        int n2 = 4;
        String string = "sr\u0000(com.jeta.forms.store.memento.FormPackage";
        for (int i = 0; i < string.length(); ++i) {
            if (byArray[i + n2] == (byte)string.charAt(i)) continue;
            bl = false;
            break;
        }
        FormMemento formMemento = null;
        if (bl) {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Object object = objectInputStream.readObject();
            formMemento = object instanceof FormPackage ? ((FormPackage)object).getMemento() : (FormMemento)object;
        } else {
            FormPackage formPackage = (FormPackage)JMLUtils.readObject(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            formMemento = formPackage.getMemento();
        }
        return formMemento;
    }

    public static FormComponent openForm(InputStream inputStream) throws FormException {
        try {
            FormMemento formMemento = FormManagerUtils.loadForm(inputStream);
            FormComponent formComponent = FormComponent.create();
            formComponent.setState(formMemento);
            return formComponent;
        }
        catch (Exception exception) {
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    public static FormComponent openPackagedForm(String string) throws FormException {
        FormUtils.safeAssert(!FormUtils.isDesignMode());
        FormUtils.safeAssert(string != null);
        FormUtils.safeAssert(string.length() > 0);
        try {
            Object object;
            Object object2;
            ProjectManager projectManager = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
            FormUtils.safeAssert(projectManager != null);
            if (projectManager != null && (object2 = projectManager.getAbsolutePath(string)) != null && ((File)(object = new File((String)object2))).isFile()) {
                return FormManagerUtils.openForm(new FileInputStream((File)object));
            }
            FormsLogger.debug("FormManagerUtils.loadForm: " + string);
            string = string.replace('\\', '/');
            object2 = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
            object = new BufferedInputStream(object2.getResourceAsStream(string), 20480);
            FormMemento formMemento = FormManagerUtils.loadForm((InputStream)object);
            FormComponent formComponent = FormComponent.create();
            formComponent.setState(formMemento);
            ((BufferedInputStream)object).close();
            return formComponent;
        }
        catch (Exception exception) {
            try {
                BeanManager beanManager = (BeanManager)JETARegistry.lookup("jeta.forms.bean.manager");
                if (beanManager != null) {
                    ClassLoader classLoader = beanManager.getClassLoader();
                    return FormManagerUtils.openForm(classLoader.getResourceAsStream(string));
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            System.out.println("FormManagerUtils.openPackgedForm failed: " + string);
            exception.printStackTrace();
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            FormsLogger.severe(I18N.format("Error_loading_form_1", string));
            throw new FormException(exception);
        }
    }
}

