/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.rzo.yajsw.io.CircularBuffer;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class NonBlockingWriter
extends Writer {
    OutputStream _out;
    CircularBuffer _buffer;
    boolean _closed = false;
    byte[] _writeBuffer;
    static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("nonblockingwriter"));

    public NonBlockingWriter(OutputStream out, int size, String fullIndicator) {
        this._out = out;
        this._buffer = new CircularBuffer(size, true);
        this._buffer.setFullIndicator(fullIndicator);
        this._buffer.setWriteBlocking(false);
        int writeSize = size / 10;
        if (writeSize > 1024) {
            writeSize = 1024;
        } else if (writeSize < 100) {
            writeSize = size / 2;
        }
        if (writeSize == 0) {
            writeSize = 1;
        }
        this._writeBuffer = new byte[writeSize];
        executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!NonBlockingWriter.this._closed) {
                    int len = NonBlockingWriter.this._buffer.get(NonBlockingWriter.this._writeBuffer, 0, NonBlockingWriter.this._writeBuffer.length);
                    try {
                        NonBlockingWriter.this._out.write(NonBlockingWriter.this._writeBuffer, 0, len);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this._buffer.write(cbuf, off, len);
    }

    public static void main(String[] args) throws IOException {
        FileOutputStream s = new FileOutputStream("c:/test.txt");
        NonBlockingWriter w = new NonBlockingWriter(s, 1024, "!!! BUFFER FULL !!!");
        for (int i = 0; i < 10000; ++i) {
            w.write("12345678\n\r");
            try {
                Thread.yield();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

