/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.config.Configuration;
import org.jboss.resteasy.spi.config.Threshold;
import org.jboss.resteasy.spi.config.security.ConfigPropertyPermission;

public class DefaultConfiguration
implements Configuration {
    private static final Function<String, String> DEFAULT_RESOLVER = new Resolver(null);
    private final Function<String, String> resolver;

    public DefaultConfiguration() {
        this(DefaultConfiguration.resolveConfiguration());
    }

    public DefaultConfiguration(ResteasyConfiguration config) {
        ResteasyConfiguration delegate = config == null ? DefaultConfiguration.resolveConfiguration() : config;
        this.resolver = delegate == null ? DEFAULT_RESOLVER : new Resolver(delegate);
    }

    @Override
    public <T> Optional<T> getOptionalValue(String name, Class<T> type) {
        Object typedValue;
        String value;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ConfigPropertyPermission(name));
        }
        if ((value = this.resolver.apply(name)) == null) {
            return Optional.empty();
        }
        if (type == String.class) {
            typedValue = type.cast(value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            typedValue = Boolean.valueOf(value);
        } else if (type == Character.class || type == Character.TYPE) {
            if (value.isEmpty()) {
                return Optional.empty();
            }
            typedValue = Character.valueOf(value.charAt(0));
        } else if (type == Byte.class || type == Byte.TYPE) {
            typedValue = Byte.valueOf(value.trim());
        } else if (type == Short.class || type == Short.TYPE) {
            typedValue = Short.valueOf(value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            typedValue = Integer.valueOf(value);
        } else if (type == Long.class || type == Long.TYPE) {
            typedValue = Long.valueOf(value);
        } else if (type == Float.class || type == Float.TYPE) {
            typedValue = Float.valueOf(value);
        } else if (type == Double.class || type == Double.TYPE) {
            typedValue = Double.valueOf(value);
        } else if (type == BigDecimal.class) {
            typedValue = new BigDecimal(value);
        } else if (type.isEnum()) {
            typedValue = Enum.valueOf(type.asSubclass(Enum.class), value);
        } else if (type == Path.class) {
            typedValue = Path.of(value, new String[0]);
        } else if (type == Threshold.class) {
            typedValue = Threshold.valueOf(value);
        } else {
            throw Messages.MESSAGES.cannotConvertParameter(value, type, name);
        }
        return Optional.of(typedValue);
    }

    @Override
    public <T> T getValue(String name, Class<T> type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ConfigPropertyPermission(name));
        }
        return this.getOptionalValue(name, type).orElseThrow(() -> Messages.MESSAGES.propertyNotFound(name));
    }

    private static ResteasyConfiguration resolveConfiguration() {
        ResteasyProviderFactory factory = ResteasyProviderFactory.peekInstance();
        return factory == null ? null : factory.getContextData(ResteasyConfiguration.class);
    }

    private static class Resolver
    implements Function<String, String> {
        private final ResteasyConfiguration config;
        private final ThreadLocal<Boolean> entered = ThreadLocal.withInitial(() -> Boolean.FALSE);

        private Resolver(ResteasyConfiguration config) {
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String apply(String name) {
            if (this.entered.get().booleanValue()) {
                return null;
            }
            try {
                this.entered.set(Boolean.TRUE);
                String value = System.getProperty(name);
                if (value == null && (value = System.getenv(name)) == null && this.config != null && (value = this.config.getInitParameter(name)) == null) {
                    value = this.config.getParameter(name);
                }
                String string = value;
                return string;
            }
            finally {
                this.entered.remove();
            }
        }
    }
}

