/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.service.LicenseService;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Deprecated
public class DownloadLicenseServlet
extends HttpServlet {
    private File license;
    private String product;
    private CloseableHttpClient client = HttpClientBuilder.create().build();
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private String downloadLicenseServer;
    private static final Logger logger = LoggerFactory.getLogger(DownloadLicenseServlet.class);

    public DownloadLicenseServlet(File license, String product) {
        this.license = license;
        this.product = product;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)((Object)this), (ServletContext)config.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.copyLicenceToTheServer(request);
            this.licenseService.reload();
        }
        catch (LicenseViolationException e) {
            FileUtils.deleteQuietly((File)this.license);
            logger.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private HttpPost createDownloadUrl(HttpServletRequest request) throws IOException, JSONException {
        String registrationData = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        JSONObject inputJson = new JSONObject(registrationData);
        String url = MessageFormat.format("{0}api/license/{1}/free", this.getDownloadServerUrl(), this.product);
        return this.submitRegistrationData(url, inputJson);
    }

    private String getDownloadServerUrl() {
        Object systemServerUrl = System.getenv("DOWNLOAD_LICENSE_SERVER_URL");
        if (StringUtils.isNotBlank((CharSequence)systemServerUrl)) {
            if (!((String)systemServerUrl).endsWith("/")) {
                systemServerUrl = (String)systemServerUrl + "/";
            }
            return systemServerUrl;
        }
        return this.downloadLicenseServer;
    }

    private void copyLicenceToTheServer(HttpServletRequest request) throws IOException, JSONException {
        HttpPost httpRequest = this.createDownloadUrl(request);
        HttpEntity licenceLinkJson = this.call((HttpRequestBase)httpRequest);
        JSONObject json = new JSONObject(IOUtils.toString((InputStream)licenceLinkJson.getContent(), (Charset)StandardCharsets.UTF_8));
        String licenseLink = json.getString("link");
        HttpGet httpGetLicense = new HttpGet(licenseLink);
        HttpEntity licence = this.call((HttpRequestBase)httpGetLicense);
        FileUtils.copyInputStreamToFile((InputStream)licence.getContent(), (File)this.license);
    }

    private HttpPost submitRegistrationData(String url, JSONObject json) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader((Header)new BasicHeader("Content-Type", "application/json"));
        httpPost.setEntity((HttpEntity)new StringEntity(json.toString(), StandardCharsets.UTF_8));
        return httpPost;
    }

    private HttpEntity call(HttpRequestBase request) throws IOException {
        CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)request);
        return httpResponse.getEntity();
    }
}

