/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.synthetic.TypeName;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;
import com.xebialabs.xlplatform.synthetic.yaml.JsonPropertySpecification;
import com.xebialabs.xlplatform.synthetic.yaml.JsonValidationRuleSpecification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class JsonSpecification {
    protected final String name;
    protected final JsonNode node;

    public JsonSpecification(String name, JsonNode node) {
        this.name = name;
        this.node = node;
    }

    public Optional<String> getLabel() {
        return this.getOptionalString("label");
    }

    public Optional<String> getDescription() {
        return this.getOptionalString("description");
    }

    public List<ValidationRuleSpecification> getValidationRules() {
        ArrayList<ValidationRuleSpecification> rules = new ArrayList<ValidationRuleSpecification>();
        if (!this.node.has("rules")) {
            return rules;
        }
        for (JsonNode ruleNode : this.node.get("rules")) {
            rules.add(new JsonValidationRuleSpecification(ruleNode));
        }
        return rules;
    }

    protected Optional<String> getOptionalString(String property) {
        return this.getOptionalString(property, null);
    }

    protected Optional<String> getOptionalString(String property, String defaultValue) {
        if (this.node.has(property)) {
            return Optional.of(this.node.get(property).asText());
        }
        return Optional.ofNullable(defaultValue);
    }

    protected Optional<Integer> getOptionalInteger(String property, Integer defaultValue) {
        if (this.node.has(property)) {
            return Optional.of(this.node.get(property).asInt());
        }
        return Optional.ofNullable(defaultValue);
    }

    protected Optional<Boolean> getOptionalBoolean(String property) {
        return this.getOptionalBoolean(property, false);
    }

    protected Optional<Boolean> getOptionalBoolean(String property, boolean defaultValue) {
        if (this.node.has(property)) {
            return Optional.of(this.node.get(property).booleanValue());
        }
        return Optional.of(defaultValue);
    }

    protected Optional<TypeName> getOptionalType(String property) {
        if (this.node.has(property)) {
            String typeName = this.node.get(property).asText();
            return Optional.of(new TypeName(typeName));
        }
        return Optional.empty();
    }

    protected List<String> getStringValues(String property) {
        ArrayList<String> aliases = new ArrayList<String>();
        if (this.node.has(property)) {
            this.node.get(property).forEach(value -> aliases.add(value.asText()));
        }
        return aliases;
    }

    protected Map<String, String> toMap(Set<String> reservedNames) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        Iterator keys = this.node.fieldNames();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (reservedNames.contains(key)) continue;
            attributes.put(key, this.node.get(key).asText());
        }
        return attributes;
    }

    protected List<JsonPropertySpecification> getProperties(String propertiesLabel) {
        ArrayList<JsonPropertySpecification> properties = new ArrayList<JsonPropertySpecification>();
        if (!this.node.has(propertiesLabel)) {
            return properties;
        }
        JsonNode propNodes = this.node.get(propertiesLabel);
        Iterator iter = propNodes.fieldNames();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            properties.add(new JsonPropertySpecification(propertyName, propNodes.get(propertyName)));
        }
        return properties;
    }
}

