/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.semver;

import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Lexer {
    public Stream<Token> tokenize(String input) {
        String origInput = input;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int tokenPos = 0;
        while (!input.isEmpty()) {
            boolean matched = false;
            for (Token.Type tokenType : Token.Type.values()) {
                Matcher matcher = tokenType.pattern.matcher(input);
                if (!matcher.find()) continue;
                matched = true;
                input = matcher.replaceFirst("");
                if (tokenType != Token.Type.WHITESPACE) {
                    Token token = new Token(tokenType, matcher.group(), tokenPos);
                    tokens.add(token);
                }
                tokenPos += matcher.end();
                break;
            }
            if (matched) continue;
            throw new IllegalArgumentException(String.format("Invalid range: '%s'.", origInput));
        }
        tokens.add(new Token(Token.Type.EOI, null, tokenPos));
        return new Stream((Object[])tokens.toArray(new Token[tokens.size()]));
    }

    static class Token {
        final Type type;
        final String lexeme;
        final int position;

        public Token(Type type, String lexeme, int position) {
            this.type = type;
            this.lexeme = lexeme == null ? "" : lexeme;
            this.position = position;
        }

        public String toString() {
            return String.format("%s(%s) at position %d", this.type.name(), this.lexeme, this.position);
        }

        public Type getType() {
            return this.type;
        }

        public String getLexeme() {
            return this.lexeme;
        }

        public int getPosition() {
            return this.position;
        }

        static enum Type implements Stream.ElementType<Token>
        {
            NUMERIC("0|[1-9][0-9]*"),
            HYPHEN("-[0-9A-Za-z]*"),
            DOT("\\."),
            WHITESPACE("\\s+"),
            EOI("?!"),
            LEFT_CLOSED("\\["),
            RIGHT_CLOSED("\\]"),
            LEFT_OPEN("\\("),
            RIGHT_OPEN("\\)"),
            COMMA("\\,");

            final Pattern pattern;

            private Type(String regexp) {
                this.pattern = Pattern.compile("^(" + regexp + ")");
            }

            public String toString() {
                return this.name() + "(" + String.valueOf(this.pattern) + ")";
            }

            public boolean isMatchedBy(Token token) {
                return token != null && this == token.type;
            }
        }
    }
}

