/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.parsing.HttpResponseParser$OneHundredContinueError$;
import org.apache.pekko.http.impl.engine.rendering.HttpRequestRendererFactory;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$CheckContentLengthTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RenderSupport$ChunkTransformer$;
import org.apache.pekko.http.impl.engine.rendering.RequestRenderingContext;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.Renderer$RenderableRenderer$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance;
import org.apache.pekko.http.scaladsl.model.RequestEntityAcceptance$Expected$;
import org.apache.pekko.http.scaladsl.model.UriRendering$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusLength$;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType;
import org.apache.pekko.http.scaladsl.model.headers.CustomHeader;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Raw$minusRequest$minusURI;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding;
import org.apache.pekko.http.scaladsl.model.headers.Transfer$minusEncoding$;
import org.apache.pekko.http.scaladsl.model.headers.User$minusAgent;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tUd!\u0002 @\u0001\u0015k\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\tI\u0003\u0001C\u0001\u0005K:\u0001\"!\t@\u0011\u0003)\u00151\u0005\u0004\b}}B\t!RA\u0013\u0011\u0019q\u0017\u0002\"\u0001\u0002(!9\u0011\u0011F\u0005\u0005\u0002\u0005-b!CA \u0013A\u0005\u0019\u0013EA!\u0011\u001d\t\u0019\u0005\u0004D\u0001\u0003\u000b:qA!\u0019\n\u0011\u0003\tyEB\u0004\u0002@%A\t!a\u0013\t\r9|A\u0011AA'\r\u0019\t\u0019f\u0004!\u0002V!Q\u0011qO\t\u0003\u0016\u0004%\t!!\u001f\t\u0013\u0005m\u0014C!E!\u0002\u0013q\bB\u00028\u0012\t\u0003\ti\bC\u0004\u0002DE!\t!!\u0012\t\u0013\u0005\u0015\u0015#!A\u0005\u0002\u0005\u001d\u0005\"CAF#E\u0005I\u0011AAG\u0011%\t\u0019+EA\u0001\n\u0003\n)\u000bC\u0005\u00028F\t\t\u0011\"\u0001\u0002:\"I\u00111X\t\u0002\u0002\u0013\u0005\u0011Q\u0018\u0005\n\u0003\u0007\f\u0012\u0011!C!\u0003\u000bD\u0011\"a5\u0012\u0003\u0003%\t!!6\t\u0013\u0005}\u0017#!A\u0005B\u0005\u0005\b\"CAs#\u0005\u0005I\u0011IAt\u0011%\tI/EA\u0001\n\u0003\nY\u000fC\u0005\u0002nF\t\t\u0011\"\u0011\u0002p\u001eI\u00111_\b\u0002\u0002#\u0005\u0011Q\u001f\u0004\n\u0003'z\u0011\u0011!E\u0001\u0003oDaA\u001c\u0012\u0005\u0002\t=\u0001\"CAuE\u0005\u0005IQIAv\u0011%\u0011\tBIA\u0001\n\u0003\u0013\u0019\u0002C\u0005\u0003\u0018\t\n\t\u0011\"!\u0003\u001a!I!\u0011\u0005\u0012\u0002\u0002\u0013%!1\u0005\u0004\u0007\u0003\u0013z\u0001I!\u0011\t\u0015\u0005\r\u0003F!f\u0001\n\u0003\t)\u0005C\u0005\u0003D!\u0012\t\u0012)A\u0005o\"1a\u000e\u000bC\u0001\u0005\u000bB\u0011\"!\")\u0003\u0003%\tA!\u0013\t\u0013\u0005-\u0005&%A\u0005\u0002\t5\u0003\"CARQ\u0005\u0005I\u0011IAS\u0011%\t9\fKA\u0001\n\u0003\tI\fC\u0005\u0002<\"\n\t\u0011\"\u0001\u0003R!I\u00111\u0019\u0015\u0002\u0002\u0013\u0005\u0013Q\u0019\u0005\n\u0003'D\u0013\u0011!C\u0001\u0005+B\u0011\"a8)\u0003\u0003%\tE!\u0017\t\u0013\u0005\u0015\b&!A\u0005B\u0005\u001d\b\"CAuQ\u0005\u0005I\u0011IAv\u0011%\ti\u000fKA\u0001\n\u0003\u0012ifB\u0005\u0003,=\t\t\u0011#\u0001\u0003.\u0019I\u0011\u0011J\b\u0002\u0002#\u0005!q\u0006\u0005\u0007]b\"\tA!\u000e\t\u0013\u0005%\b(!A\u0005F\u0005-\b\"\u0003B\tq\u0005\u0005I\u0011\u0011B\u001c\u0011%\u00119\u0002OA\u0001\n\u0003\u0013Y\u0004C\u0005\u0003\"a\n\t\u0011\"\u0003\u0003$\tQ\u0002\n\u001e;q%\u0016\fX/Z:u%\u0016tG-\u001a:fe\u001a\u000b7\r^8ss*\u0011\u0001)Q\u0001\ne\u0016tG-\u001a:j]\u001eT!AQ\"\u0002\r\u0015tw-\u001b8f\u0015\t!U)\u0001\u0003j[Bd'B\u0001$H\u0003\u0011AG\u000f\u001e9\u000b\u0005!K\u0015!\u00029fW.|'B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001e\u001c\"\u0001\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0003E\u000bQa]2bY\u0006L!a\u0015)\u0003\r\u0005s\u0017PU3g\u0003=)8/\u001a:BO\u0016tG\u000fS3bI\u0016\u00148\u0001\u0001\t\u0004\u001f^K\u0016B\u0001-Q\u0005\u0019y\u0005\u000f^5p]B\u0011!,Y\u0007\u00027*\u0011A,X\u0001\bQ\u0016\fG-\u001a:t\u0015\tqv,A\u0003n_\u0012,GN\u0003\u0002a\u000b\u0006A1oY1mC\u0012\u001cH.\u0003\u0002c7\nyQk]3sI5Lg.^:BO\u0016tG/A\u000bsKF,Xm\u001d;IK\u0006$WM]*ju\u0016D\u0015N\u001c;\u0011\u0005=+\u0017B\u00014Q\u0005\rIe\u000e^\u0001\u0004Y><\u0007CA5m\u001b\u0005Q'BA6H\u0003\u0015)g/\u001a8u\u0013\ti'N\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\rqJg.\u001b;?)\u0011\u0001(o\u001d;\u0011\u0005E\u0004Q\"A \t\u000bQ#\u0001\u0019\u0001,\t\u000b\r$\u0001\u0019\u00013\t\u000b\u001d$\u0001\u0019\u00015\u0002\u001dI,g\u000eZ3s)>\u001cv.\u001e:dKR\u0019q/a\u0004\u0011\u000badh0!\u0003\u000e\u0003eT!\u0001\u0019>\u000b\u0005m<\u0015AB:ue\u0016\fW.\u0003\u0002~s\n11k\\;sG\u0016\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u001d\u000bA!\u001e;jY&!\u0011qAA\u0001\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0004\u001f\u0006-\u0011bAA\u0007!\n\u0019\u0011I\\=\t\u000f\u0005EQ\u00011\u0001\u0002\u0014\u0005\u00191\r\u001e=\u0011\u0007E\f)\"C\u0002\u0002\u0018}\u0012qCU3rk\u0016\u001cHOU3oI\u0016\u0014\u0018N\\4D_:$X\r\u001f;\u0002\rI,g\u000eZ3s)\u0011\tiBa\u0019\u0011\u0007\u0005}AB\u0004\u0002r\u0011\u0005Q\u0002\n\u001e;q%\u0016\fX/Z:u%\u0016tG-\u001a:fe\u001a\u000b7\r^8ssB\u0011\u0011/C\n\u0003\u00139#\"!a\t\u0002\u0019I,g\u000eZ3s'R\u0014\u0018n\u0019;\u0015\u000fy\fi#a\f\u0002>!9\u0011\u0011C\u0006A\u0002\u0005M\u0001bBA\u0019\u0017\u0001\u0007\u00111G\u0001\tg\u0016$H/\u001b8hgB!\u0011QGA\u001d\u001b\t\t9DC\u0002\u00022}KA!a\u000f\u00028\tA2\t\\5f]R\u001cuN\u001c8fGRLwN\\*fiRLgnZ:\t\u000b\u001d\\\u0001\u0019\u00015\u0003-I+\u0017/^3tiJ+g\u000eZ3sS:<w*\u001e;qkR\u001c\"\u0001\u0004(\u0002\u0015\tLH/Z*ue\u0016\fW.F\u0001xS\ra\u0001&\u0005\u0002\t'R\u0014X-Y7fIN\u0011qB\u0014\u000b\u0003\u0003\u001f\u00022!!\u0015\u0010\u001b\u0005I!AB*ue&\u001cGo\u0005\u0005\u0012\u001d\u0006]\u0013\u0011LA0!\r\t\t\u0006\u0004\t\u0004\u001f\u0006m\u0013bAA/!\n9\u0001K]8ek\u000e$\b\u0003BA1\u0003crA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002jU\u000ba\u0001\u0010:p_Rt\u0014\"A)\n\u0007\u0005=\u0004+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003_\u0002\u0016!\u00022zi\u0016\u001cX#\u0001@\u0002\r\tLH/Z:!)\u0011\ty(a!\u0011\u0007\u0005\u0005\u0015#D\u0001\u0010\u0011\u0019\t9\b\u0006a\u0001}\u0006!1m\u001c9z)\u0011\ty(!#\t\u0011\u0005]d\u0003%AA\u0002y\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0010*\u001aa0!%,\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!(Q\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003C\u000b9JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000bA\u0001\\1oO*\u0011\u0011\u0011W\u0001\u0005U\u00064\u0018-\u0003\u0003\u00026\u0006-&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001e\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0003\u0002@\"A\u0011\u0011\u0019\u000e\u0002\u0002\u0003\u0007A-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000f\u0004b!!3\u0002P\u0006%QBAAf\u0015\r\ti\rU\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAi\u0003\u0017\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q[Ao!\ry\u0015\u0011\\\u0005\u0004\u00037\u0004&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0003d\u0012\u0011!a\u0001\u0003\u0013\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qUAr\u0011!\t\t-HA\u0001\u0002\u0004!\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0011\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003O\u000ba!Z9vC2\u001cH\u0003BAl\u0003cD\u0011\"!1!\u0003\u0003\u0005\r!!\u0003\u0002\rM#(/[2u!\r\t\tII\n\u0006E\u0005e(Q\u0001\t\b\u0003w\u0014\tA`A@\u001b\t\tiPC\u0002\u0002\u0000B\u000bqA];oi&lW-\u0003\u0003\u0003\u0004\u0005u(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!q\u0001B\u0007\u001b\t\u0011IA\u0003\u0003\u0003\f\u0005=\u0016AA5p\u0013\u0011\t\u0019H!\u0003\u0015\u0005\u0005U\u0018!B1qa2LH\u0003BA@\u0005+Aa!a\u001e&\u0001\u0004q\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u00057\u0011i\u0002E\u0002P/zD\u0011Ba\b'\u0003\u0003\u0005\r!a \u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003&A!\u0011\u0011\u0016B\u0014\u0013\u0011\u0011I#a+\u0003\r=\u0013'.Z2u\u0003!\u0019FO]3b[\u0016$\u0007cAAAqM)\u0001H!\r\u0003\u0006A9\u00111 B\u0001o\nM\u0002cAAAQQ\u0011!Q\u0006\u000b\u0005\u0005g\u0011I\u0004\u0003\u0004\u0002Dm\u0002\ra\u001e\u000b\u0005\u0005{\u0011y\u0004E\u0002P/^D\u0011Ba\b=\u0003\u0003\u0005\rAa\r\u0014\u0011!r\u0015qKA-\u0003?\n1BY=uKN#(/Z1nAQ!!1\u0007B$\u0011\u0019\t\u0019e\u000ba\u0001oR!!1\u0007B&\u0011!\t\u0019\u0005\fI\u0001\u0002\u00049XC\u0001B(U\r9\u0018\u0011\u0013\u000b\u0005\u0003\u0013\u0011\u0019\u0006\u0003\u0005\u0002BB\n\t\u00111\u0001e)\u0011\t9Na\u0016\t\u0013\u0005\u0005''!AA\u0002\u0005%A\u0003BAT\u00057B\u0001\"!14\u0003\u0003\u0005\r\u0001\u001a\u000b\u0005\u0003/\u0014y\u0006C\u0005\u0002BZ\n\t\u00111\u0001\u0002\n\u00051\"+Z9vKN$(+\u001a8eKJLgnZ(viB,H\u000fC\u0004\u0002\u0012\u0019\u0001\r!a\u0005\u0015\u0007y\u00149\u0007C\u0004\u0002\u0012\u001d\u0001\r!a\u0005)\u0007\u0001\u0011Y\u0007\u0005\u0003\u0003n\tETB\u0001B8\u0015\r\tijR\u0005\u0005\u0005g\u0012yGA\u0006J]R,'O\\1m\u0003BL\u0007")
@InternalApi
public class HttpRequestRendererFactory {
    private final Option<User$minusAgent> userAgentHeader;
    private final int requestHeaderSizeHint;
    private final LoggingAdapter log;

    public Source<ByteString, Object> renderToSource(RequestRenderingContext ctx) {
        return this.render(ctx).byteStream();
    }

    public RequestRenderingOutput render(RequestRenderingContext ctx) {
        ByteStringRendering r = new ByteStringRendering(this.requestHeaderSizeHint, (Function1<String, BoxedUnit>)(Function1 & Serializable)message -> {
            this.log.warning(message);
            return BoxedUnit.UNIT;
        });
        HttpRequestRendererFactory.renderRequestLine$1(r, ctx);
        this.renderHeaders$1(ctx.request().headers().toList(), false, false, false, ctx, r);
        RenderSupport$.MODULE$.renderEntityContentType(r, ctx.request().entity());
        return HttpRequestRendererFactory.completeRequestRendering$1(ctx, r);
    }

    public ByteString renderStrict(RequestRenderingContext ctx) {
        RequestRenderingOutput requestRenderingOutput = this.render(ctx);
        if (requestRenderingOutput instanceof RequestRenderingOutput.Strict) {
            return ((RequestRenderingOutput.Strict)requestRenderingOutput).bytes();
        }
        if (requestRenderingOutput instanceof RequestRenderingOutput.Streamed) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Request entity was not Strict but ").append(ctx.request().entity().getClass().getSimpleName()).toString());
        }
        throw new MatchError((Object)requestRenderingOutput);
    }

    public static final /* synthetic */ boolean $anonfun$render$2(ByteStringRendering r$1, HttpHeader x0$1) {
        if (x0$1 instanceof Raw$minusRequest$minusURI) {
            String rawUri = ((Raw$minusRequest$minusURI)x0$1).uri();
            r$1.$tilde$tilde(rawUri);
            return true;
        }
        return false;
    }

    private static final void renderRequestLine$1(ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        ((ByteStringRendering)r$1.$tilde$tilde(ctx$1.request().method(), Renderer$RenderableRenderer$.MODULE$)).$tilde$tilde(' ');
        if (!ctx$1.request().headers().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestRendererFactory.$anonfun$render$2(r$1, x0$1)))) {
            UriRendering$.MODULE$.renderUriWithoutFragment(r$1, ctx$1.request().uri(), package$.MODULE$.UTF8());
        }
        ((ByteStringRendering)r$1.$tilde$tilde(' ').$tilde$tilde(ctx$1.request().protocol(), Renderer$RenderableRenderer$.MODULE$)).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
    }

    private static final ByteStringRendering render$1(HttpHeader h, ByteStringRendering r$1) {
        return (ByteStringRendering)r$1.$tilde$tilde(h);
    }

    private final void renderHeaders$1(List remaining, boolean hostHeaderSeen, boolean userAgentSeen, boolean transferEncodingSeen, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        while (remaining instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)remaining;
            HttpHeader head = (HttpHeader)colon2.head();
            List tail = colon2.next$access$1();
            boolean bl = false;
            RawHeader rawHeader = null;
            if (head instanceof Content$minusLength) {
                Content$minusLength content$minusLength = (Content$minusLength)head;
                String suppressionWarning_msg = "explicit `Content-Length` header is not allowed. Use the appropriate HttpEntity subtype.";
                this.log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)content$minusLength, (Object)suppressionWarning_msg);
                Object var19_19 = null;
                remaining = tail;
                continue;
            }
            if (head instanceof Content$minusType) {
                Content$minusType content$minusType = (Content$minusType)head;
                String suppressionWarning_msg = "explicit `Content-Type` header is not allowed. Set `HttpRequest.entity.contentType` instead.";
                this.log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)content$minusType, (Object)suppressionWarning_msg);
                Object var20_20 = null;
                remaining = tail;
                continue;
            }
            if (head instanceof Transfer$minusEncoding) {
                Option<Transfer$minusEncoding> option = ((Transfer$minusEncoding)head).withChunkedPeeled();
                if (None$.MODULE$.equals(option)) {
                    String suppressionWarning_msg = "the pekko-http-core layer sets this header automatically!";
                    this.log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)head, (Object)suppressionWarning_msg);
                    Object var21_21 = null;
                    remaining = tail;
                    continue;
                }
                if (option instanceof Some) {
                    Transfer$minusEncoding te = (Transfer$minusEncoding)((Some)option).value();
                    Transfer$minusEncoding render$1_h = ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() ? te.withChunked() : te;
                    ByteStringRendering cfr_ignored_0 = (ByteStringRendering)r$1.$tilde$tilde(render$1_h);
                    Object var22_22 = null;
                    transferEncodingSeen = true;
                    remaining = tail;
                    continue;
                }
                throw new MatchError(option);
            }
            if (head instanceof Host) {
                Host host = (Host)head;
                ByteStringRendering cfr_ignored_1 = (ByteStringRendering)r$1.$tilde$tilde(host);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (head instanceof User$minusAgent) {
                User$minusAgent user$minusAgent = (User$minusAgent)head;
                ByteStringRendering cfr_ignored_2 = (ByteStringRendering)r$1.$tilde$tilde(user$minusAgent);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (head instanceof Raw$minusRequest$minusURI) {
                remaining = tail;
                continue;
            }
            if (head instanceof CustomHeader) {
                CustomHeader customHeader = (CustomHeader)head;
                if (customHeader.renderInRequests()) {
                    ByteStringRendering cfr_ignored_3 = (ByteStringRendering)r$1.$tilde$tilde(customHeader);
                }
                remaining = tail;
                continue;
            }
            if (head instanceof RawHeader) {
                bl = true;
                rawHeader = (RawHeader)head;
                if (rawHeader.is("content-type") || rawHeader.is("content-length") || rawHeader.is("transfer-encoding")) {
                    String suppressionWarning_msg = "illegal RawHeader";
                    this.log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)rawHeader, (Object)suppressionWarning_msg);
                    Object var23_23 = null;
                    remaining = tail;
                    continue;
                }
            }
            if (bl && rawHeader.is("user-agent")) {
                ByteStringRendering cfr_ignored_4 = (ByteStringRendering)r$1.$tilde$tilde(rawHeader);
                userAgentSeen = true;
                remaining = tail;
                continue;
            }
            if (bl && rawHeader.is("host")) {
                ByteStringRendering cfr_ignored_5 = (ByteStringRendering)r$1.$tilde$tilde(rawHeader);
                hostHeaderSeen = true;
                remaining = tail;
                continue;
            }
            if (head.renderInRequests()) {
                ByteStringRendering cfr_ignored_6 = (ByteStringRendering)r$1.$tilde$tilde(head);
            } else {
                this.log.warning("HTTP header '{}' is not allowed in requests", (Object)head);
            }
            remaining = tail;
        }
        if (Nil$.MODULE$.equals(remaining)) {
            if (!hostHeaderSeen) {
                r$1.$tilde$tilde(ctx$1.hostHeader());
            }
            if (!userAgentSeen && this.userAgentHeader.isDefined()) {
                r$1.$tilde$tilde((HttpHeader)this.userAgentHeader.get());
            }
            if (ctx$1.request().entity().isChunked() && !ctx$1.request().entity().isKnownEmpty() && !transferEncodingSeen) {
                ((ByteStringRendering)r$1.$tilde$tilde(Transfer$minusEncoding$.MODULE$, Renderer$RenderableRenderer$.MODULE$)).$tilde$tilde(RenderSupport$.MODULE$.ChunkedBytes()).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
                return;
            }
        } else {
            throw new MatchError((Object)remaining);
        }
    }

    private static final boolean renderHeaders$default$2$1() {
        return false;
    }

    private static final boolean renderHeaders$default$3$1() {
        return false;
    }

    private static final boolean renderHeaders$default$4$1() {
        return false;
    }

    private static final ByteStringRendering renderContentLength$1(long contentLength, RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        block2: {
            block3: {
                if (!ctx$1.request().method().isEntityAccepted()) break block2;
                if (contentLength > 0L) break block3;
                RequestEntityAcceptance requestEntityAcceptance = ctx$1.request().method().requestEntityAcceptance();
                RequestEntityAcceptance$Expected$ requestEntityAcceptance$Expected$ = RequestEntityAcceptance$Expected$.MODULE$;
                if (requestEntityAcceptance == null || !requestEntityAcceptance.equals(requestEntityAcceptance$Expected$)) break block2;
            }
            return ((ByteStringRendering)r$1.$tilde$tilde(Content$minusLength$.MODULE$, Renderer$RenderableRenderer$.MODULE$).$tilde$tilde(contentLength)).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
        }
        return r$1;
    }

    private static final RequestRenderingOutput renderStreamed$1(Source body, ByteStringRendering r$1, RequestRenderingContext ctx$1) {
        Source source;
        Source headerPart = Source$.MODULE$.single((Object)r$1.get());
        Option<Future<NotUsed>> option = ctx$1.sendEntityTrigger();
        if (None$.MODULE$.equals(option)) {
            source = (Source)headerPart.$plus$plus((Graph)body);
        } else if (option instanceof Some) {
            Future future = (Future)((Some)option).value();
            Source barrier = (Source)Source$.MODULE$.fromFuture(future).drop(1L);
            source = (Source)headerPart.$plus$plus((Graph)barrier).$plus$plus((Graph)body).recoverWithRetries(-1, (PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (HttpResponseParser$OneHundredContinueError$.MODULE$.equals(x1)) {
                        return (B1)Source$.MODULE$.empty();
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return HttpResponseParser$OneHundredContinueError$.MODULE$.equals(x1);
                }
            });
        } else {
            throw new MatchError(option);
        }
        Source stream = source;
        return new RequestRenderingOutput.Streamed((Source<ByteString, Object>)stream);
    }

    private static final RequestRenderingOutput completeRequestRendering$1(RequestRenderingContext ctx$1, ByteStringRendering r$1) {
        RequestEntity requestEntity = ctx$1.request().entity();
        if (requestEntity.isKnownEmpty()) {
            HttpRequestRendererFactory.renderContentLength$1(0L, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return new RequestRenderingOutput.Strict(r$1.get());
        }
        if (requestEntity instanceof HttpEntity.Strict) {
            ByteString data = ((HttpEntity.Strict)requestEntity).data();
            HttpRequestRendererFactory.renderContentLength$1(data.length(), ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            if (ctx$1.sendEntityTrigger().isDefined()) {
                return HttpRequestRendererFactory.renderStreamed$1(Source$.MODULE$.single((Object)data), r$1, ctx$1);
            }
            return new RequestRenderingOutput.Strict(r$1.get().$plus$plus(data));
        }
        if (requestEntity instanceof HttpEntity.Default) {
            HttpEntity.Default default_ = (HttpEntity.Default)requestEntity;
            long contentLength = default_.contentLength();
            Source<ByteString, Object> data = default_.data();
            HttpRequestRendererFactory.renderContentLength$1(contentLength, ctx$1, r$1).$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(data.via(RenderSupport$CheckContentLengthTransformer$.MODULE$.flow(contentLength)), r$1, ctx$1);
        }
        if (requestEntity instanceof HttpEntity.Chunked) {
            Source<HttpEntity.ChunkStreamPart, Object> chunks = ((HttpEntity.Chunked)requestEntity).chunks();
            r$1.$tilde$tilde(RenderSupport$.MODULE$.CrLf());
            return HttpRequestRendererFactory.renderStreamed$1(chunks.via(RenderSupport$ChunkTransformer$.MODULE$.flow()), r$1, ctx$1);
        }
        throw new MatchError((Object)requestEntity);
    }

    public HttpRequestRendererFactory(Option<User$minusAgent> userAgentHeader, int requestHeaderSizeHint, LoggingAdapter log) {
        this.userAgentHeader = userAgentHeader;
        this.requestHeaderSizeHint = requestHeaderSizeHint;
        this.log = log;
    }

    public static interface RequestRenderingOutput {
        public Source<ByteString, Object> byteStream();
    }
}

