/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.DocumentedConfigObservation;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryContext;
import org.springframework.cloud.config.server.environment.ObservationEnvironmentRepositoryObservationConvention;

public final class ObservationEnvironmentRepositoryWrapper
implements EnvironmentRepository {
    private static final ObservationEnvironmentRepositoryObservationConvention CONVENTION = new ObservationEnvironmentRepositoryObservationConvention();
    private final ObservationRegistry registry;
    private final EnvironmentRepository delegate;

    private ObservationEnvironmentRepositoryWrapper(ObservationRegistry registry, EnvironmentRepository delegate) {
        this.registry = registry;
        this.delegate = delegate;
    }

    public static EnvironmentRepository wrap(ObservationRegistry observationRegistry, EnvironmentRepository delegate) {
        if (delegate instanceof ObservationEnvironmentRepositoryWrapper) {
            return delegate;
        }
        return new ObservationEnvironmentRepositoryWrapper(observationRegistry, delegate);
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        ObservationEnvironmentRepositoryContext context = new ObservationEnvironmentRepositoryContext(this.delegate.getClass(), application, profile, label);
        return (Environment)DocumentedConfigObservation.ENVIRONMENT_REPOSITORY.observation(null, CONVENTION, () -> context, this.registry).observe(() -> this.delegate.findOne(application, profile, label));
    }

    @Override
    public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        ObservationEnvironmentRepositoryContext context = new ObservationEnvironmentRepositoryContext(this.delegate.getClass(), application, profile, label);
        return (Environment)DocumentedConfigObservation.ENVIRONMENT_REPOSITORY.observation(null, CONVENTION, () -> context, this.registry).observe(() -> this.delegate.findOne(application, profile, label, includeOrigin));
    }

    public EnvironmentRepository getDelegate() {
        return this.delegate;
    }
}

