/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.server.Continuation;
import org.rzo.netty.ahessian.rpc.server.ContinuationService;
import org.rzo.netty.ahessian.session.Session;

class DefaultContinuation
implements Continuation,
Constants {
    private ContinuationService _service;
    private HessianRPCCallMessage _message;
    private Map _headers;
    private boolean _completed = false;
    private Date _ttl;
    private Session _session = null;

    DefaultContinuation(HessianRPCCallMessage message, ContinuationService service, Session session) {
        Long ttl;
        this._service = service;
        this._message = message;
        this._headers = this._message.getHeaders();
        if (this._headers == null) {
            this._headers = new HashMap();
        }
        this._ttl = (ttl = (Long)this._headers.get("TTL")) == null ? new Date(Long.MAX_VALUE) : new Date(System.currentTimeMillis() + ttl);
        this._headers.put(COMPLETED_HEADER_KEY, Boolean.FALSE);
        this._session = session;
    }

    @Override
    public void complete(Object result) {
        this.checkCompleted();
        this._completed = true;
        this.sendReply(result, null);
    }

    @Override
    public void fault(Throwable result) {
        this.checkCompleted();
        this._completed = true;
        this.sendReply(null, result);
    }

    @Override
    public Date getTTL() {
        return this._ttl;
    }

    @Override
    public void send(Object result) {
        this.checkCompleted();
        this.sendReply(result, null);
    }

    private void checkCompleted() {
        if (this._completed) {
            throw new RuntimeException("Continuation already completed");
        }
        if (System.currentTimeMillis() > this._ttl.getTime()) {
            this._completed = true;
            throw new RuntimeException("Continuation already completed");
        }
    }

    private void sendReply(Object result, Object fault) {
        if (this._completed) {
            this._headers.put(COMPLETED_HEADER_KEY, Boolean.TRUE);
        }
        this._service.writeResult(new HessianRPCReplyMessage(result, fault, this._message));
    }

    @Override
    public Session getSession() {
        return this._session;
    }
}

