/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.core.util.MemberDictionary;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ElementIgnoringMapper
extends MapperWrapper {
    private final MemberDictionary fieldsToOmit = new MemberDictionary();
    private final Map unknownElementsToIgnore = new LinkedHashMap();

    public ElementIgnoringMapper(Mapper wrapped) {
        super(wrapped);
    }

    public void addElementsToIgnore(Pattern pattern) {
        this.unknownElementsToIgnore.put(pattern.pattern(), pattern);
    }

    public void omitField(Class definedIn, String fieldName) {
        this.fieldsToOmit.add(definedIn, fieldName);
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        if (this.fieldsToOmit.contains(definedIn, fieldName)) {
            return false;
        }
        if (definedIn == Object.class && this.isIgnoredElement(fieldName)) {
            return false;
        }
        return super.shouldSerializeMember(definedIn, fieldName);
    }

    public boolean isIgnoredElement(String name) {
        if (!this.unknownElementsToIgnore.isEmpty()) {
            Iterator iter = this.unknownElementsToIgnore.values().iterator();
            while (iter.hasNext()) {
                Pattern pattern = (Pattern)iter.next();
                if (!pattern.matcher(name).matches()) continue;
                return true;
            }
        }
        return super.isIgnoredElement(name);
    }
}

