/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asyncutil.locks;

import com.ibm.asyncutil.locks.AsyncEpochImpl;
import com.ibm.asyncutil.locks.StripedEpoch;
import com.ibm.asyncutil.locks.TerminatedEpoch;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface AsyncEpoch {
    public Optional<EpochToken> enter();

    public CompletionStage<Boolean> terminate();

    public boolean isTerminated();

    public CompletionStage<Void> awaitCompletion();

    public static AsyncEpoch newUncontendedEpoch() {
        return new AsyncEpochImpl();
    }

    public static AsyncEpoch newContendedEpoch() {
        return new StripedEpoch();
    }

    public static AsyncEpoch newEpoch() {
        return new StripedEpoch();
    }

    public static AsyncEpoch newTerminatedEpoch() {
        return TerminatedEpoch.INSTANCE;
    }

    public static interface EpochToken
    extends AutoCloseable {
        @Override
        public void close();
    }
}

