/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.concurrent.atomic.AtomicInteger;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;

public class FunctionThread
extends Thread {
    private final PyObject func;
    private final PyObject[] args;
    private final PySystemState systemState;
    private static AtomicInteger counter = new AtomicInteger();

    public FunctionThread(PyObject func, PyObject[] args, long stack_size, ThreadGroup group) {
        super(group, null, "Thread", stack_size);
        this.func = func;
        this.args = args;
        this.systemState = Py.getSystemState();
        this.setName("Thread-" + Integer.toString(counter.incrementAndGet()));
    }

    @Override
    public void run() {
        Py.setSystemState(this.systemState);
        try {
            this.func.__call__(this.args);
        }
        catch (PyException exc) {
            if (exc.match(Py.SystemExit)) {
                return;
            }
            Py.stderr.println("Unhandled exception in thread started by " + this.func);
            Py.printException(exc);
        }
    }

    @Override
    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return String.format("FunctionThread[%s,%s,%s]", this.getName(), this.getPriority(), group.getName());
        }
        return String.format("FunctionThread[%s,%s]", this.getName(), this.getPriority());
    }
}

