/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.heartbeat;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import java.util.Date;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.heartbeat.HeartbeatHandlerInbound;
import org.rzo.netty.ahessian.heartbeat.TimedOutAction;

public class ServerHeartbeatHandler
extends ChannelInboundHandlerAdapter
implements TimedOutAction {
    static final ReadTimeoutException EXCEPTION = ReadTimeoutException.INSTANCE;
    HeartbeatHandlerInbound _handler;

    public ServerHeartbeatHandler(HeartbeatHandlerInbound handler) {
        this._handler = handler;
        this._handler.setAction(this);
    }

    @Override
    public void timedOut(ChannelHandlerContext ctx) {
        Constants.ahessianLogger.info("no reads since " + new Date(this._handler.getLastCalled()) + " -> close channel");
        ctx.channel().close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this._handler.ping();
        ctx.fireChannelRead(msg);
    }
}

