/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.mongodb.MongoException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MongoDbEnvironmentProperties;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class MongoDbEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final Log logger = LogFactory.getLog(JdbcEnvironmentRepository.class);
    private final MongoTemplate mongoTemplate;
    private final MongoDbEnvironmentProperties properties;

    public MongoDbEnvironmentRepository(MongoTemplate mongoTemplate, MongoDbEnvironmentProperties properties) {
        this.mongoTemplate = mongoTemplate;
        this.properties = properties;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        label = StringUtils.hasText((String)label) ? label : this.properties.getDefaultLabel();
        profile = StringUtils.hasText((String)profile) ? profile : "default";
        String[] profilesArray = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profilesArray, label, null, null);
        Object config = application.startsWith("application") ? application : "application," + application;
        List applications = Arrays.stream(StringUtils.commaDelimitedListToStringArray((String)config)).distinct().collect(Collectors.toList());
        List profiles = Arrays.stream(profilesArray).distinct().collect(Collectors.toList());
        Collections.reverse(applications);
        Collections.reverse(profiles);
        for (String env : profiles) {
            for (String app : applications) {
                this.addPropertySource(environment, app, env, label);
            }
        }
        for (String app : applications) {
            this.addPropertySource(environment, app, null, label);
        }
        return environment;
    }

    private void addPropertySource(Environment environment, String application, String profile, String label) {
        try {
            Criteria criteria = Criteria.where((String)"application").is((Object)application).and("label").is((Object)label);
            criteria = profile != null ? criteria.and("profile").is((Object)profile) : criteria.andOperator(new Criteria[]{Criteria.where((String)"profile").is(null)});
            Query query = new Query((CriteriaDefinition)criteria);
            List propertyMaps = this.mongoTemplate.find(query, Map.class, this.properties.getCollection());
            for (Map propertyMap : propertyMaps) {
                String propertySourceName;
                String string = propertySourceName = profile != null ? application + "-" + profile : application;
                Map source = (Map)propertyMap.get("properties");
                if (source == null || source.isEmpty()) continue;
                environment.add(new PropertySource(propertySourceName, source));
            }
        }
        catch (MongoException | DataAccessException e) {
            if (!this.properties.isFailOnError()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failed to retrieve configuration from MongoDB", e);
                }
            }
            throw e;
        }
    }

    public int getOrder() {
        return this.properties.getOrder();
    }
}

