/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.cloud.oslogin.common.OsLoginProto;
import com.google.cloud.oslogin.v1.ImportSshPublicKeyResponse;
import com.google.cloud.oslogin.v1.LoginProfile;
import com.google.cloud.oslogin.v1.OsLoginServiceClient;
import com.google.cloud.oslogin.v1.OsLoginServiceSettings;
import com.google.cloud.oslogin.v1.UserName;
import com.xebialabs.overthere.gcp.GcpKeyManager;
import com.xebialabs.overthere.gcp.GcpSshKey;
import com.xebialabs.overthere.gcp.GenerateSshKey;
import com.xebialabs.overthere.gcp.SshKeyPair;
import com.xebialabs.overthere.gcp.credentials.GcpCredentialFactory;
import com.xebialabs.overthere.gcp.credentials.ProjectCredentials;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcpOsLoginKeyManager
implements GcpKeyManager {
    private static final Logger logger = LoggerFactory.getLogger(GcpOsLoginKeyManager.class);
    private final GcpCredentialFactory gcpCredentialFactory;
    private final GenerateSshKey generateSshKey;
    private ProjectCredentials projectCredentials;
    private UserName userName;
    private OsLoginServiceSettings osLoginServiceSettings;
    private GcpSshKey gcpSshKey;

    GcpOsLoginKeyManager(GenerateSshKey generateSshKey, GcpCredentialFactory gcpCredentialFactory) {
        this.generateSshKey = generateSshKey;
        this.gcpCredentialFactory = gcpCredentialFactory;
    }

    @Override
    public GcpKeyManager init() {
        try {
            this.projectCredentials = this.gcpCredentialFactory.create();
            this.userName = UserName.of((String)this.projectCredentials.getClientEmail());
            this.osLoginServiceSettings = ((OsLoginServiceSettings.Builder)OsLoginServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)this.projectCredentials.getCredentials()))).build();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot initialize for " + this.gcpCredentialFactory.info(), e);
        }
        return this;
    }

    @Override
    public GcpSshKey refreshKey(long expiryInMs, int keySize) {
        if (this.gcpSshKey == null || System.currentTimeMillis() + 1000L > this.gcpSshKey.getExpirationTimeMs()) {
            SshKeyPair sshKeyPair = this.generateSshKey.generate(this.projectCredentials.getClientEmail(), keySize);
            long expirationTimeMs = System.currentTimeMillis() + expiryInMs;
            LoginProfile loginProfile = this.importSssKeyProjectLevel(sshKeyPair, expiryInMs * 1000L);
            int posixAccountsCount = loginProfile.getPosixAccountsCount();
            if (posixAccountsCount < 1) {
                throw new IllegalArgumentException("Cannot get account for " + this.gcpCredentialFactory.info() + " has no posix account");
            }
            OsLoginProto.PosixAccount posixAccount = loginProfile.getPosixAccounts(0);
            Map sshPublicKeysMap = loginProfile.getSshPublicKeysMap();
            OsLoginProto.SshPublicKey sshPublicKey = (OsLoginProto.SshPublicKey)sshPublicKeysMap.get(sshKeyPair.getFingerPrint());
            if (sshPublicKey != null) {
                expirationTimeMs = sshPublicKey.getExpirationTimeUsec() / 1000L;
            }
            logger.debug("Using new key pair for user {} it expires at {} ms", (Object)posixAccount.getUsername(), (Object)expirationTimeMs);
            this.gcpSshKey = new GcpSshKey(sshKeyPair, posixAccount.getUsername(), expirationTimeMs);
        }
        return this.gcpSshKey;
    }

    protected LoginProfile importSssKeyProjectLevel(SshKeyPair sshKeyPair, long expiryInUsec) {
        LoginProfile loginProfile;
        block8: {
            OsLoginServiceClient osLoginServiceClient = OsLoginServiceClient.create((OsLoginServiceSettings)this.osLoginServiceSettings);
            try {
                OsLoginProto.SshPublicKey sshPublicKey = this.createSshPublicKey(sshKeyPair, expiryInUsec);
                ImportSshPublicKeyResponse importSshPublicKeyResponse = osLoginServiceClient.importSshPublicKey(this.userName, sshPublicKey, this.projectCredentials.getProjectId());
                loginProfile = importSshPublicKeyResponse.getLoginProfile();
                if (osLoginServiceClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (osLoginServiceClient != null) {
                        try {
                            osLoginServiceClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot use credentials from " + this.gcpCredentialFactory.info(), e);
                }
            }
            osLoginServiceClient.close();
        }
        return loginProfile;
    }

    private OsLoginProto.SshPublicKey createSshPublicKey(SshKeyPair sshKeyPair, long expiryInUsec) {
        return OsLoginProto.SshPublicKey.newBuilder().setKey(sshKeyPair.getPublicKey()).setExpirationTimeUsec(System.currentTimeMillis() * 1000L + expiryInUsec).build();
    }
}

