/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.authorization.method.AuthorizationAdvisor;

class MethodSecurityAdvisorRegistrar
implements ImportBeanDefinitionRegistrar {
    MethodSecurityAdvisorRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerAsAdvisor("preFilterAuthorization", registry);
        this.registerAsAdvisor("preAuthorizeAuthorization", registry);
        this.registerAsAdvisor("postFilterAuthorization", registry);
        this.registerAsAdvisor("postAuthorizeAuthorization", registry);
        this.registerAsAdvisor("securedAuthorization", registry);
        this.registerAsAdvisor("jsr250Authorization", registry);
        this.registerAsAdvisor("authorizeReturnObject", registry);
    }

    private void registerAsAdvisor(String prefix, BeanDefinitionRegistry registry) {
        String advisorName = prefix + "Advisor";
        if (registry.containsBeanDefinition(advisorName)) {
            return;
        }
        String interceptorName = prefix + "MethodInterceptor";
        if (!registry.containsBeanDefinition(interceptorName)) {
            return;
        }
        BeanDefinition definition = registry.getBeanDefinition(interceptorName);
        if (!(definition instanceof RootBeanDefinition)) {
            return;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(AdvisorWrapper.class);
        builder.setFactoryMethod("of");
        builder.setRole(2);
        builder.addConstructorArgReference(interceptorName);
        RootBeanDefinition advisor = (RootBeanDefinition)builder.getBeanDefinition();
        advisor.setTargetType(Advisor.class);
        registry.registerBeanDefinition(advisorName, (BeanDefinition)advisor);
    }

    public static final class AdvisorWrapper
    implements PointcutAdvisor,
    MethodInterceptor,
    Ordered,
    AopInfrastructureBean {
        private final AuthorizationAdvisor advisor;

        private AdvisorWrapper(AuthorizationAdvisor advisor) {
            this.advisor = advisor;
        }

        public static AdvisorWrapper of(AuthorizationAdvisor advisor) {
            return new AdvisorWrapper(advisor);
        }

        public Advice getAdvice() {
            return this.advisor.getAdvice();
        }

        public Pointcut getPointcut() {
            return this.advisor.getPointcut();
        }

        public int getOrder() {
            return this.advisor.getOrder();
        }

        @Nullable
        public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
            return this.advisor.invoke(invocation);
        }
    }
}

