/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.shell;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.shell.CollectionCompleter;
import org.hyperic.sigar.shell.ShellBase;

public class FileCompleter
extends CollectionCompleter
implements FilenameFilter {
    private static final String HOME = System.getProperty("user.home");
    private String name;

    public FileCompleter() {
    }

    public FileCompleter(ShellBase shell) {
        super(shell);
    }

    public static String expand(String name) {
        if (name.startsWith("~")) {
            return HOME + name.substring(1, name.length());
        }
        return name;
    }

    public boolean accept(File dir, String name) {
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        return name.startsWith(this.name);
    }

    public Iterator getIterator() {
        return null;
    }

    private String appendSep(String name) {
        if (name.endsWith(File.separator)) {
            return name;
        }
        return name + File.separator;
    }

    private boolean isDotFile(File file) {
        return file.getName().equals(".") && file.getParentFile() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String complete(String line) {
        String[] list;
        File dir;
        File file;
        String fileName = line;
        boolean isHome = false;
        if (line.length() == 0) {
            return this.appendSep(".");
        }
        if (fileName.startsWith("~")) {
            isHome = true;
            fileName = FileCompleter.expand(fileName);
        }
        if ((file = new File(fileName)).exists() && !this.isDotFile(file)) {
            if (!file.isDirectory()) return line;
            this.name = null;
            dir = file;
            if (!fileName.endsWith(File.separator)) {
                return line + File.separator;
            }
        } else {
            this.name = file.getName();
            dir = file.getParentFile();
            if (dir == null) {
                if (!SigarLoader.IS_WIN32 || line.length() != 1 || !Character.isLetter(line.charAt(0))) return line;
                return line + ":\\";
            }
            if (!dir.exists() || !dir.isDirectory()) {
                return line;
            }
        }
        if ((list = this.name == null ? dir.list() : dir.list(this)).length == 1) {
            fileName = this.appendSep(dir.toString()) + list[0];
            if (new File(fileName).isDirectory()) {
                fileName = this.appendSep(fileName);
            }
            if (!isHome) return fileName;
            return "~" + fileName.substring(HOME.length(), fileName.length());
        }
        String partial = this.displayPossible(list);
        if (partial == null) return line;
        return this.appendSep(dir.toString()) + partial;
    }

    public static void main(String[] args) throws Exception {
        String line = new FileCompleter().complete(args[0]);
        System.out.println("\nsigar> '" + line + "'");
    }
}

