/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.support;

import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class PassphraseCredentialsProvider
extends CredentialsProvider {
    public static final String PROMPT = "Passphrase";
    private final char[] passphrase;

    public PassphraseCredentialsProvider(String passphrase) {
        this.passphrase = passphrase.toCharArray();
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.InformationalMessage || item instanceof CredentialItem.Password && item.getPromptText().equals(PROMPT)) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.InformationalMessage) continue;
            if (item instanceof CredentialItem.Password && item.getPromptText().equals(PROMPT)) {
                ((CredentialItem.Password)item).setValue(this.passphrase);
                continue;
            }
            throw new UnsupportedCredentialItem(uri, item.getClass().getName() + ":" + item.getPromptText());
        }
        return true;
    }
}

