/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2;

import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.FrameLogger;
import org.apache.pekko.http.impl.engine.http2.FrameLogger$LogEntry$2$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.BidiFlow;
import org.apache.pekko.stream.scaladsl.BidiFlow$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public final class FrameLogger$ {
    public static final FrameLogger$ MODULE$ = new FrameLogger$();

    public final int maxBytes() {
        return 16;
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> logFramesIfEnabled(boolean shouldLog) {
        if (shouldLog) {
            return this.bidi();
        }
        return BidiFlow$.MODULE$.identity();
    }

    public BidiFlow<FrameEvent, FrameEvent, FrameEvent, FrameEvent, NotUsed> bidi() {
        Flow qual$1 = Flow$.MODULE$.apply();
        Function1 & Serializable x$2 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEvent)frameEvent);
        LoggingAdapter x$3 = qual$1.log$default$3("\u001b[31mDOWN\u001b[0m", (Function1)x$2);
        Flow qual$2 = Flow$.MODULE$.apply();
        Function1 & Serializable x$5 = (Function1 & Serializable)frameEvent -> MODULE$.logEvent((FrameEvent)frameEvent);
        LoggingAdapter x$6 = qual$2.log$default$3("\u001b[32m UP \u001b[0m", (Function1)x$5);
        return BidiFlow$.MODULE$.fromFlows((Graph)qual$1.log("\u001b[31mDOWN\u001b[0m", (Function1)x$2, x$3), (Graph)qual$2.log("\u001b[32m UP \u001b[0m", (Function1)x$5, x$6)).addAttributes(Attributes$.MODULE$.apply((Attributes.Attribute)new Attributes.LogLevels(Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel(), Logging$.MODULE$.DebugLevel())));
    }

    public String logEvent(FrameEvent frameEvent) {
        new LazyRef();
        public class Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1
        implements Product,
        Serializable {
            private final int streamId;
            private final String shortFrameType;
            private final String extraInfo;
            private final Seq<Option<String>> flags;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public int streamId() {
                return this.streamId;
            }

            public String shortFrameType() {
                return this.shortFrameType;
            }

            public String extraInfo() {
                return this.extraInfo;
            }

            public Seq<Option<String>> flags() {
                return this.flags;
            }

            public String productPrefix() {
                return "LogEntry";
            }

            public int productArity() {
                return 4;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToInteger((int)this.streamId());
                    }
                    case 1: {
                        return this.shortFrameType();
                    }
                    case 2: {
                        return this.extraInfo();
                    }
                    case 3: {
                        return this.flags();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "streamId";
                    }
                    case 1: {
                        return "shortFrameType";
                    }
                    case 2: {
                        return "extraInfo";
                    }
                    case 3: {
                        return "flags";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"LogEntry".hashCode()), (int)this.streamId()), (int)Statics.anyHash((Object)this.shortFrameType())), (int)Statics.anyHash((Object)this.extraInfo())), (int)Statics.anyHash(this.flags())), (int)4);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        if (!(x$1 instanceof Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1)) break block3;
                        Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1 var2_2 = (Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1)x$1;
                        if (this.streamId() != var2_2.streamId()) break block3;
                        String string = this.shortFrameType();
                        String string2 = var2_2.shortFrameType();
                        if (string != null ? !string.equals(string2) : string2 != null) break block3;
                        String string3 = this.extraInfo();
                        String string4 = var2_2.extraInfo();
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                        Seq<Option<String>> seq = this.flags();
                        Seq<Option<String>> seq2 = var2_2.flags();
                        if (seq != null ? !seq.equals(seq2) : seq2 != null) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(int streamId, String shortFrameType, String extraInfo, Seq<Option<String>> flags) {
                this.streamId = streamId;
                this.shortFrameType = shortFrameType;
                this.extraInfo = extraInfo;
                this.flags = flags;
                Product.$init$((Product)this);
            }
        }
        return FrameLogger$.display$1(this.entryForFrame$1(frameEvent));
    }

    private String formatSettings(Seq<FrameEvent.Setting> s2) {
        return ((IterableOnceOps)s2.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Http2Protocol.SettingIdentifier id = x0$1.identifier();
                int value = x0$1.value();
                return new StringBuilder(4).append(id).append(" -> ").append(value).toString();
            }
            throw new MatchError(null);
        })).mkString(", ");
    }

    private static final /* synthetic */ FrameLogger$LogEntry$2$ LogEntry$lzycompute$1(LazyRef LogEntry$module$1) {
        synchronized (LogEntry$module$1) {
            FrameLogger$LogEntry$2$ frameLogger$LogEntry$2$ = LogEntry$module$1.initialized() ? (FrameLogger$LogEntry$2$)LogEntry$module$1.value() : (FrameLogger$LogEntry$2$)LogEntry$module$1.initialize((Object)new FrameLogger$LogEntry$2$());
            return frameLogger$LogEntry$2$;
        }
    }

    private final FrameLogger$LogEntry$2$ LogEntry$3(LazyRef LogEntry$module$1) {
        if (LogEntry$module$1.initialized()) {
            return (FrameLogger$LogEntry$2$)LogEntry$module$1.value();
        }
        return FrameLogger$.LogEntry$lzycompute$1(LogEntry$module$1);
    }

    private static final Option flag$1(boolean value, String name) {
        if (value) {
            return new Some((Object)name);
        }
        return None$.MODULE$;
    }

    private static final String hex$1(ByteString bytes) {
        int num = package$.MODULE$.min(16, bytes.size());
        String ellipsis = num < bytes.size() ? new StringBuilder(18).append(" [... ").append(bytes.size() - num).append(" more bytes]").toString() : "";
        return new StringBuilder(0).append(((IterableOnceOps)bytes.take(num).map((Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})))).mkString(" ")).append(ellipsis).toString();
    }

    private final FrameLogger.LogEntry.1 entryForFrame$1(FrameEvent frameEvent) {
        boolean bl = false;
        FrameEvent.PingFrame pingFrame = null;
        if (frameEvent instanceof FrameEvent.PingFrame) {
            bl = true;
            pingFrame = (FrameEvent.PingFrame)frameEvent;
            boolean bl2 = pingFrame.ack();
            ByteString data = pingFrame.data();
            if (!bl2) {
                return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "PING", FrameLogger$.hex$1(data), (Seq<Option<String>>)Nil$.MODULE$);
            }
        }
        if (bl) {
            boolean bl3 = pingFrame.ack();
            ByteString data = pingFrame.data();
            if (bl3) {
                return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "PONG", FrameLogger$.hex$1(data), (Seq<Option<String>>)Nil$.MODULE$);
            }
        }
        if (frameEvent instanceof FrameEvent.HeadersFrame) {
            FrameEvent.HeadersFrame headersFrame = (FrameEvent.HeadersFrame)frameEvent;
            int streamId = headersFrame.streamId();
            boolean endStream = headersFrame.endStream();
            boolean endHeaders = headersFrame.endHeaders();
            ByteString payload = headersFrame.headerBlockFragment();
            Option<FrameEvent.PriorityFrame> prio = headersFrame.priorityInfo();
            String prioInfo = prio.isDefined() ? new StringBuilder(1).append(FrameLogger$.display$1(this.entryForFrame$1((FrameEvent)prio.get()))).append(" ").toString() : "";
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "HEAD", new StringBuilder(0).append(prioInfo).append(FrameLogger$.hex$1(payload)).toString(), (Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(endStream, "ES"), FrameLogger$.flag$1(endHeaders, "EH")}));
        }
        if (frameEvent instanceof FrameEvent.ContinuationFrame) {
            FrameEvent.ContinuationFrame continuationFrame = (FrameEvent.ContinuationFrame)frameEvent;
            int streamId = continuationFrame.streamId();
            boolean endHeaders = continuationFrame.endHeaders();
            ByteString payload = continuationFrame.payload();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "CONT", FrameLogger$.hex$1(payload), (Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(endHeaders, "EH")}));
        }
        if (frameEvent instanceof FrameEvent.DataFrame) {
            FrameEvent.DataFrame dataFrame = (FrameEvent.DataFrame)frameEvent;
            int streamId = dataFrame.streamId();
            boolean endStream = dataFrame.endStream();
            ByteString payload = dataFrame.payload();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "DATA", FrameLogger$.hex$1(payload), (Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(endStream, "ES")}));
        }
        if (frameEvent instanceof FrameEvent.GoAwayFrame) {
            FrameEvent.GoAwayFrame goAwayFrame = (FrameEvent.GoAwayFrame)frameEvent;
            int lastStreamId = goAwayFrame.lastStreamId();
            Http2Protocol.ErrorCode errorCode = goAwayFrame.errorCode();
            ByteString debug = goAwayFrame.debug();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "GOAY", new StringBuilder(39).append("lastStreamId = ").append(lastStreamId).append(", errorCode = ").append(errorCode).append(", debug = ").append(debug.utf8String()).toString(), (Seq<Option<String>>)Nil$.MODULE$);
        }
        if (frameEvent instanceof FrameEvent.ParsedHeadersFrame) {
            FrameEvent.ParsedHeadersFrame parsedHeadersFrame = (FrameEvent.ParsedHeadersFrame)frameEvent;
            int streamId = parsedHeadersFrame.streamId();
            boolean endStream = parsedHeadersFrame.endStream();
            Seq<Tuple2<String, Object>> kvPairs = parsedHeadersFrame.keyValuePairs();
            Option<FrameEvent.PriorityFrame> prio = parsedHeadersFrame.priorityInfo();
            String prioInfo = prio.isDefined() ? new StringBuilder(1).append(FrameLogger$.display$1(this.entryForFrame$1((FrameEvent)prio.get()))).append(" ").toString() : "";
            String kvInfo = ((IterableOnceOps)kvPairs.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String key = (String)x0$1._1();
                    Object value = x0$1._2();
                    return new StringBuilder(4).append(key).append(" -> ").append(value).toString();
                }
                throw new MatchError(null);
            })).mkString(", ");
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "HEAD", new StringBuilder(0).append(prioInfo).append(kvInfo).toString(), (Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(endStream, "ES")}));
        }
        if (frameEvent instanceof FrameEvent.PriorityFrame) {
            FrameEvent.PriorityFrame priorityFrame = (FrameEvent.PriorityFrame)frameEvent;
            int streamId = priorityFrame.streamId();
            boolean exclusive = priorityFrame.exclusiveFlag();
            int streamDependency = priorityFrame.streamDependency();
            int weight = priorityFrame.weight();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "PRIO", new StringBuilder(29).append("streamDependency = ").append(streamDependency).append(", weight: ").append(weight).toString(), (Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{FrameLogger$.flag$1(exclusive, "EX")}));
        }
        if (frameEvent instanceof FrameEvent.RstStreamFrame) {
            FrameEvent.RstStreamFrame rstStreamFrame = (FrameEvent.RstStreamFrame)frameEvent;
            int streamId = rstStreamFrame.streamId();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame.errorCode();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "RSET", errorCode.toString(), (Seq<Option<String>>)Nil$.MODULE$);
        }
        if (frameEvent instanceof FrameEvent.SettingsFrame) {
            String settingsInfo = ((IterableOnceOps)((FrameEvent.SettingsFrame)frameEvent).settings().map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    Http2Protocol.SettingIdentifier id = x0$2.identifier();
                    int value = x0$2.value();
                    return new StringBuilder(4).append(id).append(" -> ").append(value).toString();
                }
                throw new MatchError(null);
            })).mkString(", ");
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "SETT", settingsInfo, (Seq<Option<String>>)Nil$.MODULE$);
        }
        if (frameEvent instanceof FrameEvent.SettingsAckFrame) {
            Seq<FrameEvent.Setting> s2 = ((FrameEvent.SettingsAckFrame)frameEvent).acked();
            String acksInfo = this.formatSettings(s2);
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "SETA", acksInfo, (Seq<Option<String>>)Nil$.MODULE$);
        }
        if (frameEvent instanceof FrameEvent.WindowUpdateFrame) {
            FrameEvent.WindowUpdateFrame windowUpdateFrame = (FrameEvent.WindowUpdateFrame)frameEvent;
            int streamId = windowUpdateFrame.streamId();
            int windowSizeIncrement = windowUpdateFrame.windowSizeIncrement();
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamId, "WIND", new StringBuilder(2).append("+ ").append(windowSizeIncrement).toString(), (Seq<Option<String>>)Nil$.MODULE$);
        }
        if (frameEvent instanceof FrameEvent.StreamFrameEvent) {
            FrameEvent.StreamFrameEvent streamFrameEvent = (FrameEvent.StreamFrameEvent)frameEvent;
            return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(streamFrameEvent.streamId(), "UNKN", streamFrameEvent.toString(), (Seq<Option<String>>)Nil$.MODULE$);
        }
        return new Org_apache_pekko_http_impl_engine_http2_FrameLogger$LogEntry$1(0, "UNKN", frameEvent.toString(), (Seq<Option<String>>)Nil$.MODULE$);
    }

    private static final String display$1(FrameLogger.LogEntry.1 entry) {
        return StringOps$.MODULE$.format$extension("%s%4d %s%s %s%s %s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[32m", BoxesRunTime.boxToInteger((int)entry.streamId()), "\u001b[33m", entry.shortFrameType(), "\u001b[31m", ((IterableOnceOps)entry.flags().flatMap((Function1 & Serializable)x -> x)).mkString(" "), "\u001b[0m", entry.extraInfo()}));
    }

    private FrameLogger$() {
    }
}

