/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.config;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.rzo.yajsw.util.VFSUtils;

public class FilePropertiesConfiguration
extends PropertiesConfiguration {
    String _fileName;
    File _url;
    FileSystem _fileSystem;
    String _encoding;

    public FilePropertiesConfiguration(File file) throws Exception {
        this._fileName = file.getAbsolutePath();
        this.init();
        this.load();
    }

    public FilePropertiesConfiguration() {
        this.init();
    }

    private void init() {
        this.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        MyFileLocationStrategy strategy = new MyFileLocationStrategy();
        String basePath = this._fileName == null ? "." : new File(this._fileName).getParent();
        FileLocator locator = FileLocatorUtils.fileLocator().locationStrategy((FileLocationStrategy)strategy).basePath(basePath).create();
        this.initFileLocator(locator);
    }

    public String getPath() {
        return this._fileName;
    }

    public String getFileName() {
        try {
            return VFSUtils.resolveFile(".", this._fileName).getName().getBaseName();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return this._fileName;
        }
    }

    public String getURL() throws Exception {
        return this._fileName;
    }

    public FileSystem getFileSystem() {
        return this._fileSystem;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        try (Reader reader = null;){
            FileObject f = VFSUtils.resolveFile(".", this._fileName);
            InputStream in = f.getContent().getInputStream();
            reader = new InputStreamReader(in);
            this.read(reader);
        }
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void reload() throws Exception {
        super.clear();
        this.load();
    }

    public FilePropertiesConfiguration interpolatedFileConfiguration() {
        FilePropertiesConfiguration result = new FilePropertiesConfiguration();
        result.copy(this.interpolatedConfiguration());
        result.setFileName(this._fileName);
        return result;
    }

    public void save(File cn) throws Exception {
        FileWriter writer = new FileWriter(cn);
        this.write(writer);
        ((Writer)writer).close();
    }

    public class MyFileLocationStrategy
    implements FileLocationStrategy {
        public URL locate(FileSystem fileSystem, FileLocator locator) {
            try {
                FileObject file = VFSUtils.resolveFile(FilePropertiesConfiguration.this._fileName);
                String base = VFSUtils.isLocal(file) ? new File(FilePropertiesConfiguration.this._fileName).getParent() : file.getParent().getURL().toString();
                return VFSUtils.resolveFile(base, locator.getFileName()).getURL();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

