/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.IOOperationIncompleteException;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.io.FileSource$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.CompactByteString$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005=rA\u0002\t\u0012\u0011\u00039RD\u0002\u0004 #!\u0005q\u0003\t\u0005\u0006O\u0005!\t!\u000b\u0005\bU\u0005\u0011\r\u0011\"\u0001,\u0011\u0019y\u0013\u0001)A\u0005Y\u0019)q$\u0005\u0002\u0018%\"A1.\u0002B\u0001B\u0003%A\u000e\u0003\u0005s\u000b\t\u0005\t\u0015!\u0003M\u0011!\u0019XA!A!\u0002\u0013!\b\"B\u0014\u0006\t\u00039\bb\u0002?\u0006\u0005\u0004%\t! \u0005\b\u0003\u0007)\u0001\u0015!\u0003\u007f\u0011%\t)!\u0002b\u0001\n\u0003\n9\u0001C\u0004\u0002\n\u0015\u0001\u000b\u0011B-\t\u000f\u0005-Q\u0001\"\u0011\u0002\u000e!9\u0011QE\u0003\u0005B\u0005\u001d\u0012A\u0003$jY\u0016\u001cv.\u001e:dK*\u0011!cE\u0001\u0003S>T!\u0001F\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003-]\taa\u001d;sK\u0006l'B\u0001\r\u001a\u0003\u0015\u0001Xm[6p\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0011\u0005y\tQ\"A\t\u0003\u0015\u0019KG.Z*pkJ\u001cWm\u0005\u0002\u0002CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002;\u0005\t2m\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0016\u00031\u00122!\f\u00199\r\u0011qC\u0001\u0001\u0017\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002%\r|W\u000e\u001d7fi&|g\u000eS1oI2,'\u000f\t\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3diB!\u0011H\u0010!D\u001b\u0005Q$BA\u001e=\u0003!\u0019\u0007.\u00198oK2\u001c(BA\u001f5\u0003\rq\u0017n\\\u0005\u0003\u007fi\u0012\u0011cQ8na2,G/[8o\u0011\u0006tG\r\\3s!\t\t\u0014)\u0003\u0002Ce\t9\u0011J\u001c;fO\u0016\u0014\b\u0003\u0002\u0012E\r>K!!R\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA$K\u00196\t\u0001J\u0003\u0002JG\u0005!Q\u000f^5m\u0013\tY\u0005JA\u0002Uef\u0004\"AI'\n\u00059\u001b#aA%oiB\u0011!\u0005U\u0005\u0003#\u000e\u0012A!\u00168jiN\u0011Qa\u0015\t\u0005)^K&-D\u0001V\u0015\t1V#A\u0003ti\u0006<W-\u0003\u0002Y+\nyrI]1qQN#\u0018mZ3XSRDW*\u0019;fe&\fG.\u001b>fIZ\u000bG.^3\u0011\u0007i[V,D\u0001\u0016\u0013\taVCA\u0006T_V\u00148-Z*iCB,\u0007C\u00010a\u001b\u0005y&BA%\u0018\u0013\t\twL\u0001\u0006CsR,7\u000b\u001e:j]\u001e\u00042a\u00194i\u001b\u0005!'BA3$\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003O\u0012\u0014aAR;ukJ,\u0007C\u0001.j\u0013\tQWC\u0001\u0005J\u001fJ+7/\u001e7u\u0003\u0011\u0001\u0018\r\u001e5\u0011\u00055\u0004X\"\u00018\u000b\u0005=d\u0014\u0001\u00024jY\u0016L!!\u001d8\u0003\tA\u000bG\u000f[\u0001\nG\",hn[*ju\u0016\fQb\u001d;beR\u0004vn]5uS>t\u0007C\u0001\u0012v\u0013\t18E\u0001\u0003M_:<G\u0003\u0002=zun\u0004\"AH\u0003\t\u000b-L\u0001\u0019\u00017\t\u000bIL\u0001\u0019\u0001'\t\u000bML\u0001\u0019\u0001;\u0002\u0007=,H/F\u0001\u007f!\rQv0X\u0005\u0004\u0003\u0003)\"AB(vi2,G/\u0001\u0003pkR\u0004\u0013!B:iCB,W#A-\u0002\rMD\u0017\r]3!\u0003}\u0019'/Z1uK2{w-[2B]\u0012l\u0015\r^3sS\u0006d\u0017N_3e-\u0006dW/\u001a\u000b\u0005\u0003\u001f\tY\u0002\u0005\u0004#\u0003#\t)BY\u0005\u0004\u0003'\u0019#A\u0002+va2,'\u0007E\u0002U\u0003/I1!!\u0007V\u0005=9%/\u00199i'R\fw-\u001a'pO&\u001c\u0007bBA\u000f\u001d\u0001\u0007\u0011qD\u0001\u0014S:DWM]5uK\u0012\fE\u000f\u001e:jEV$Xm\u001d\t\u00045\u0006\u0005\u0012bAA\u0012+\tQ\u0011\t\u001e;sS\n,H/Z:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000b\u0011\u0007E\nY#C\u0002\u0002.I\u0012aa\u0015;sS:<\u0007")
public final class FileSource
extends GraphStageWithMaterializedValue<SourceShape<ByteString>, Future<IOResult>> {
    public final Path org$apache$pekko$stream$impl$io$FileSource$$path;
    public final int org$apache$pekko$stream$impl$io$FileSource$$chunkSize;
    public final long org$apache$pekko$stream$impl$io$FileSource$$startPosition;
    private final Outlet<ByteString> out;
    private final SourceShape<ByteString> shape;

    public static CompletionHandler<Integer, Function1<Try<Object>, BoxedUnit>> completionHandler() {
        return FileSource$.MODULE$.completionHandler();
    }

    public Outlet<ByteString> out() {
        return this.out;
    }

    @Override
    public SourceShape<ByteString> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<IOResult>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise ioResultPromise = Promise$.MODULE$.apply();
        OutHandler logic = new OutHandler(this, inheritedAttributes, ioResultPromise){
            private final ByteBuffer buffer;
            private final int maxReadAhead;
            private FileChannel channel;
            private long position;
            private Function1<Try<Object>, BoxedUnit> chunkCallback;
            private boolean eofEncountered;
            private Vector<ByteString> availableChunks;
            private final /* synthetic */ FileSource $outer;
            private final Promise ioResultPromise$1;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public ByteBuffer buffer() {
                return this.buffer;
            }

            public int maxReadAhead() {
                return this.maxReadAhead;
            }

            public FileChannel channel() {
                return this.channel;
            }

            public void channel_$eq(FileChannel x$1) {
                this.channel = x$1;
            }

            public long position() {
                return this.position;
            }

            public void position_$eq(long x$1) {
                this.position = x$1;
            }

            public Function1<Try<Object>, BoxedUnit> chunkCallback() {
                return this.chunkCallback;
            }

            public void chunkCallback_$eq(Function1<Try<Object>, BoxedUnit> x$1) {
                this.chunkCallback = x$1;
            }

            public boolean eofEncountered() {
                return this.eofEncountered;
            }

            public void eofEncountered_$eq(boolean x$1) {
                this.eofEncountered = x$1;
            }

            public Vector<ByteString> availableChunks() {
                return this.availableChunks;
            }

            public void availableChunks_$eq(Vector<ByteString> x$1) {
                this.availableChunks = x$1;
            }

            public void preStart() {
                try {
                    if (!Files.exists(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, new LinkOption[0])) {
                        throw new NoSuchFileException(((Object)this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path).toString());
                    }
                    Predef$.MODULE$.require(!Files.isDirectory(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, new LinkOption[0]), (Function0 & Serializable)() -> new StringBuilder(22).append("Path '").append($this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path).append("' is a directory").toString());
                    Predef$.MODULE$.require(Files.isReadable(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path), (Function0 & Serializable)() -> new StringBuilder(30).append("Missing read permission for '").append($this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path).append("'").toString());
                    this.channel_$eq(FileChannel.open(this.$outer.org$apache$pekko$stream$impl$io$FileSource$$path, StandardOpenOption.READ));
                    this.channel().position(this.position());
                    return;
                }
                catch (Exception ex) {
                    this.ioResultPromise$1.trySuccess((Object)new IOResult(this.position(), (Try<Done>)new Failure((Throwable)ex)));
                    throw ex;
                }
            }

            public void onPull() {
                if (this.availableChunks().size() < this.maxReadAhead() && !this.eofEncountered()) {
                    this.availableChunks_$eq(this.readAhead(this.maxReadAhead(), this.availableChunks()));
                }
                if (this.availableChunks().nonEmpty()) {
                    this.emitMultiple(this.$outer.out(), this.availableChunks().iterator(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                        if (this.eofEncountered()) {
                            this.success();
                            return;
                        }
                        this.setHandler($this.$outer.out(), this);
                    });
                    this.availableChunks_$eq((Vector<ByteString>)package$.MODULE$.Vector().empty());
                    return;
                }
                if (this.eofEncountered()) {
                    this.success();
                    return;
                }
            }

            private void success() {
                this.completeStage();
                this.ioResultPromise$1.trySuccess((Object)new IOResult(this.position(), (Try<Done>)new Success((Object)Done$.MODULE$)));
            }

            public Vector<ByteString> readAhead(int maxChunks, Vector<ByteString> chunks) {
                while (chunks.size() < maxChunks && !this.eofEncountered()) {
                    int n;
                    try {
                        n = this.channel().read(this.buffer(), this.position());
                    }
                    catch (Throwable throwable) {
                        if (NonFatal$.MODULE$.apply(throwable)) {
                            this.failStage(throwable);
                            this.ioResultPromise$1.trySuccess((Object)new IOResult(this.position(), (Try<Done>)new Failure(throwable)));
                            throw throwable;
                        }
                        throw throwable;
                    }
                    int readBytes = n;
                    if (readBytes > 0) {
                        this.buffer().flip();
                        this.position_$eq(this.position() + (long)readBytes);
                        ByteBuffer fromByteBuffer_buffer = this.buffer();
                        Object var6_5 = null;
                        Vector newChunks = (Vector)chunks.$colon$plus((Object)CompactByteString$.MODULE$.apply(fromByteBuffer_buffer));
                        this.buffer().clear();
                        if (readBytes < this.$outer.org$apache$pekko$stream$impl$io$FileSource$$chunkSize) {
                            this.eofEncountered_$eq(true);
                            return newChunks;
                        }
                        chunks = newChunks;
                        continue;
                    }
                    this.eofEncountered_$eq(true);
                    return chunks;
                }
                return chunks;
            }

            public void onDownstreamFinish(Throwable cause) {
                if (cause instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                    this.success();
                    return;
                }
                this.ioResultPromise$1.tryFailure((Throwable)new IOOperationIncompleteException("Downstream failed before reaching file end", this.position(), cause));
                this.completeStage();
            }

            public void postStop() {
                this.ioResultPromise$1.trySuccess((Object)new IOResult(this.position(), (Try<Done>)new Success((Object)Done$.MODULE$)));
                if (this.channel() != null && this.channel().isOpen()) {
                    this.channel().close();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ioResultPromise$1 = ioResultPromise$1;
                super($outer.shape());
                this.buffer = ByteBuffer.allocate($outer.org$apache$pekko$stream$impl$io$FileSource$$chunkSize);
                this.maxReadAhead = inheritedAttributes$1.get(new Attributes.InputBuffer(16, 16), ClassTag$.MODULE$.apply(Attributes.InputBuffer.class)).max();
                this.position = $outer.org$apache$pekko$stream$impl$io$FileSource$$startPosition;
                this.eofEncountered = false;
                this.availableChunks = package$.MODULE$.Vector().empty();
                this.setHandler($outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPull$1(org.apache.pekko.stream.impl.io.FileSource$$anon$2 ), $anonfun$preStart$1(org.apache.pekko.stream.impl.io.FileSource$$anon$2 ), $anonfun$preStart$2(org.apache.pekko.stream.impl.io.FileSource$$anon$2 )}, serializedLambda);
            }
        };
        return new Tuple2((Object)logic, (Object)ioResultPromise.future());
    }

    public String toString() {
        return new StringBuilder(14).append("FileSource(").append(this.org$apache$pekko$stream$impl$io$FileSource$$path).append(", ").append(this.org$apache$pekko$stream$impl$io$FileSource$$chunkSize).append(")").toString();
    }

    public FileSource(Path path, int chunkSize, long startPosition) {
        this.org$apache$pekko$stream$impl$io$FileSource$$path = path;
        this.org$apache$pekko$stream$impl$io$FileSource$$chunkSize = chunkSize;
        this.org$apache$pekko$stream$impl$io$FileSource$$startPosition = startPosition;
        Predef$.MODULE$.require(chunkSize > 0, (Function0 & Serializable)() -> "chunkSize must be greater than 0");
        String apply_name = "FileSource.out";
        Object var5_4 = null;
        this.out = new Outlet(apply_name);
        this.shape = new SourceShape<ByteString>(this.out());
    }
}

