/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import java.io.Closeable;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Configurable;
import org.eclipse.jetty.websocket.api.Frame;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;

public interface Session
extends Configurable,
Closeable {
    public void demand();

    public void sendBinary(ByteBuffer var1, Callback var2);

    public void sendPartialBinary(ByteBuffer var1, boolean var2, Callback var3);

    public void sendText(String var1, Callback var2);

    public void sendPartialText(String var1, boolean var2, Callback var3);

    public void sendPing(ByteBuffer var1, Callback var2);

    public void sendPong(ByteBuffer var1, Callback var2);

    @Override
    default public void close() {
        this.close(1000, null, Callback.NOOP);
    }

    public void close(int var1, String var2, Callback var3);

    public void disconnect();

    public SocketAddress getLocalSocketAddress();

    public SocketAddress getRemoteSocketAddress();

    public String getProtocolVersion();

    public UpgradeRequest getUpgradeRequest();

    public UpgradeResponse getUpgradeResponse();

    public boolean isOpen();

    public boolean isSecure();

    public static interface Listener {
        default public void onWebSocketOpen(Session session) {
        }

        default public void onWebSocketFrame(Frame frame, Callback callback) {
        }

        default public void onWebSocketPing(ByteBuffer payload) {
        }

        default public void onWebSocketPong(ByteBuffer payload) {
        }

        default public void onWebSocketPartialBinary(ByteBuffer payload, boolean last, Callback callback) {
        }

        default public void onWebSocketPartialText(String payload, boolean last) {
        }

        default public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        }

        default public void onWebSocketText(String message) {
        }

        default public void onWebSocketError(Throwable cause) {
        }

        default public void onWebSocketClose(int statusCode, String reason) {
        }

        public static abstract class AbstractAutoDemanding
        extends Abstract
        implements AutoDemanding {
        }

        public static abstract class Abstract
        implements Listener {
            private volatile Session session;

            @Override
            public void onWebSocketOpen(Session session) {
                this.session = session;
            }

            public Session getSession() {
                return this.session;
            }

            public boolean isOpen() {
                Session session = this.session;
                return session != null && session.isOpen();
            }
        }

        public static interface AutoDemanding
        extends Listener {
        }
    }
}

