/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.Config;

public class WindowCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private int packedGitOpenFiles = 128;
    private long packedGitLimit = 0xA00000L;
    private boolean useStrongRefs = false;
    private boolean useStrongIndexRefs = true;
    private int packedGitWindowSize = 8192;
    private boolean packedGitMMAP = false;
    private int deltaBaseCacheLimit = 0xA00000;
    private int streamFileThreshold = 0x3200000;
    private boolean exposeStats = true;

    public int getPackedGitOpenFiles() {
        return this.packedGitOpenFiles;
    }

    public void setPackedGitOpenFiles(int fdLimit) {
        this.packedGitOpenFiles = fdLimit;
    }

    public long getPackedGitLimit() {
        return this.packedGitLimit;
    }

    public void setPackedGitLimit(long newLimit) {
        this.packedGitLimit = newLimit;
    }

    public boolean isPackedGitUseStrongRefs() {
        return this.useStrongRefs;
    }

    public void setPackedGitUseStrongRefs(boolean useStrongRefs) {
        this.useStrongRefs = useStrongRefs;
    }

    public boolean isPackedIndexGitUseStrongRefs() {
        return this.useStrongIndexRefs;
    }

    public void setPackedIndexGitUseStrongRefs(boolean useStrongRefs) {
        this.useStrongIndexRefs = useStrongRefs;
    }

    public int getPackedGitWindowSize() {
        return this.packedGitWindowSize;
    }

    public void setPackedGitWindowSize(int newSize) {
        this.packedGitWindowSize = newSize;
    }

    public boolean isPackedGitMMAP() {
        return this.packedGitMMAP;
    }

    public void setPackedGitMMAP(boolean usemmap) {
        this.packedGitMMAP = usemmap;
    }

    public int getDeltaBaseCacheLimit() {
        return this.deltaBaseCacheLimit;
    }

    public void setDeltaBaseCacheLimit(int newLimit) {
        this.deltaBaseCacheLimit = newLimit;
    }

    public int getStreamFileThreshold() {
        return this.streamFileThreshold;
    }

    public void setStreamFileThreshold(int newLimit) {
        this.streamFileThreshold = newLimit;
    }

    public boolean getExposeStatsViaJmx() {
        return this.exposeStats;
    }

    public void setExposeStatsViaJmx(boolean expose) {
        this.exposeStats = expose;
    }

    public WindowCacheConfig fromConfig(Config rc) {
        this.setPackedGitUseStrongRefs(rc.getBoolean("core", "packedgitusestrongrefs", this.isPackedGitUseStrongRefs()));
        this.setPackedIndexGitUseStrongRefs(rc.getBoolean("core", "packedindexgitusestrongrefs", this.isPackedIndexGitUseStrongRefs()));
        this.setPackedGitOpenFiles(rc.getInt("core", null, "packedgitopenfiles", this.getPackedGitOpenFiles()));
        this.setPackedGitLimit(rc.getLong("core", null, "packedgitlimit", this.getPackedGitLimit()));
        this.setPackedGitWindowSize(rc.getInt("core", null, "packedgitwindowsize", this.getPackedGitWindowSize()));
        this.setPackedGitMMAP(rc.getBoolean("core", null, "packedgitmmap", this.isPackedGitMMAP()));
        this.setDeltaBaseCacheLimit(rc.getInt("core", null, "deltaBaseCacheLimit", this.getDeltaBaseCacheLimit()));
        long maxMem = Runtime.getRuntime().maxMemory();
        long sft = rc.getLong("core", null, "streamFileThreshold", this.getStreamFileThreshold());
        sft = Math.min(sft, maxMem / 4L);
        sft = Math.min(sft, Integer.MAX_VALUE);
        this.setStreamFileThreshold((int)sft);
        return this;
    }

    public void install() {
        WindowCache.reconfigure(this);
    }
}

