/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32.test;

import java.util.List;
import org.hyperic.sigar.test.SigarTestCase;
import org.hyperic.sigar.win32.Service;
import org.hyperic.sigar.win32.ServiceConfig;
import org.hyperic.sigar.win32.Win32Exception;

public class TestService
extends SigarTestCase {
    private static final String TEST_NAME = "MyTestService";
    private static final String PREFIX = "sigar.test.service.";
    private static final boolean TEST_CREATE = "true".equals(System.getProperty("sigar.test.service.create"));
    private static final boolean TEST_DELETE = "true".equals(System.getProperty("sigar.test.service.delete"));

    public TestService(String name) {
        super(name);
    }

    public void testServiceOpen() throws Exception {
        Service service = new Service("Eventlog");
        service.getConfig();
        service.close();
        String dummyName = "DOESNOTEXIST";
        try {
            new Service(dummyName);
            TestService.assertTrue((boolean)false);
        }
        catch (Win32Exception e) {
            this.traceln(dummyName + ": " + e.getMessage());
            TestService.assertTrue((boolean)true);
        }
    }

    public void testServiceNames() throws Exception {
        List services = Service.getServiceNames();
        this.assertGtZeroTrace("getServiceNames", services.size());
        String[] ptql = new String[]{"Service.Name.ct=Ev", "Service.Path.ew=.exe"};
        for (int i = 0; i < ptql.length; ++i) {
            services = Service.getServiceNames(this.getSigar(), ptql[i]);
            this.assertGtZeroTrace(ptql[i], services.size());
        }
        String[] invalid = new String[]{"State.Name.ct=Ev", "Service.Invalid.ew=.exe", "-"};
        for (int i = 0; i < invalid.length; ++i) {
            try {
                services = Service.getServiceNames(this.getSigar(), invalid[i]);
                TestService.fail((String)("'" + invalid[i] + "' did not throw Exception"));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void testServiceConfig() throws Exception {
        List configs = Service.getServiceConfigs(this.getSigar(), "svchost.exe");
        this.assertGtZeroTrace("getServiceConfigs", configs.size());
    }

    public void testServiceCreateDelete() throws Exception {
        if (!TEST_CREATE) {
            return;
        }
        ServiceConfig config = new ServiceConfig(TEST_NAME);
        config.setStartType(3);
        config.setDisplayName("My Test Service");
        config.setDescription("A Description of " + config.getDisplayName());
        config.setPath("C:\\Program Files\\My Test 1.0\\mytest.exe");
        Service.create(config);
    }

    public void testDeleteService() throws Exception {
        if (!TEST_DELETE) {
            return;
        }
        Service service = new Service(TEST_NAME);
        service.delete();
    }
}

