/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.List;

public class SyncListener<E>
implements ListEventListener<E> {
    private EventList<E> source;
    private List<E> target;
    private int targetSize;

    public SyncListener(EventList<E> source, List<E> target) {
        this.source = source;
        this.target = target;
        target.clear();
        target.addAll(source);
        this.targetSize = target.size();
        source.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        EventList<E> sourceList = listChanges.getSourceList();
        if (this.target.size() != this.targetSize) {
            throw new IllegalStateException("Synchronize EventList target has been modified");
        }
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int type = listChanges.getType();
            if (type == 2) {
                this.target.add(index, sourceList.get(index));
                ++this.targetSize;
                continue;
            }
            if (type == 1) {
                this.target.set(index, sourceList.get(index));
                continue;
            }
            if (type != 0) continue;
            this.target.remove(index);
            --this.targetSize;
        }
    }

    public void dispose() {
        if (this.source != null) {
            this.source.removeListEventListener(this);
            this.source = null;
            this.target = null;
        }
    }
}

