/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.model;

import java.util.Map;
import org.apache.pekko.http.javadsl.model.ContentTypes;
import org.apache.pekko.http.javadsl.model.HttpCharset;
import org.apache.pekko.http.javadsl.model.HttpCharsets;
import org.apache.pekko.http.javadsl.model.HttpEntities;
import org.apache.pekko.http.javadsl.model.Query;
import org.apache.pekko.http.javadsl.model.RequestEntity;
import org.apache.pekko.japi.Pair;

public final class FormData {
    private final Query fields;
    public static final FormData EMPTY = new FormData(Query.EMPTY);

    public FormData(Query query) {
        this.fields = query;
    }

    public RequestEntity toEntity() {
        return this.toEntity(HttpCharsets.UTF_8);
    }

    @Deprecated
    public RequestEntity toEntity(HttpCharset httpCharset) {
        return HttpEntities.create(ContentTypes.APPLICATION_X_WWW_FORM_URLENCODED, this.fields.render(httpCharset));
    }

    @SafeVarargs
    public static FormData create(Pair<String, String> ... pairArray) {
        return new FormData(Query.create(pairArray));
    }

    public static FormData create(Map<String, String> map) {
        return new FormData(Query.create(map));
    }

    public static FormData create(Iterable<Pair<String, String>> iterable) {
        return new FormData(Query.create(iterable));
    }
}

